/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocElement;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public final class ConfigDocKey
implements ConfigDocElement,
Comparable<ConfigDocElement> {
    private String type;
    private String key;
    private String configDoc;
    private boolean withinAMap;
    private String defaultValue;
    private String javaDocSiteLink;
    private String docMapKey;
    private ConfigPhase configPhase;
    private List<String> acceptedValues;
    private boolean optional;
    private boolean list;
    private boolean passThroughMap;

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasAcceptedValues() {
        return this.acceptedValues != null && !this.acceptedValues.isEmpty();
    }

    public List<String> getAcceptedValues() {
        return this.acceptedValues;
    }

    public void setAcceptedValues(List<String> acceptedValues) {
        this.acceptedValues = acceptedValues;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getConfigDoc() {
        return this.configDoc;
    }

    public void setConfigDoc(String configDoc) {
        this.configDoc = configDoc;
    }

    public String getJavaDocSiteLink() {
        if (this.javaDocSiteLink == null) {
            return "";
        }
        return this.javaDocSiteLink;
    }

    public void setJavaDocSiteLink(String javaDocSiteLink) {
        this.javaDocSiteLink = javaDocSiteLink;
    }

    public String getDefaultValue() {
        if (!this.defaultValue.isEmpty()) {
            return this.defaultValue;
        }
        String defaultValue = DocGeneratorUtil.getPrimitiveDefaultValue(this.type);
        if (defaultValue == null) {
            return "";
        }
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public ConfigPhase getConfigPhase() {
        return this.configPhase;
    }

    public void setConfigPhase(ConfigPhase configPhase) {
        this.configPhase = configPhase;
    }

    public void setWithinAMap(boolean withinAMap) {
        this.withinAMap = withinAMap;
    }

    @Override
    public boolean isWithinAMap() {
        return this.withinAMap;
    }

    String computeTypeSimpleName() {
        String unwrappedType = DocGeneratorUtil.unbox(this.type);
        Matcher matcher = Constants.CLASS_NAME_PATTERN.matcher(unwrappedType);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return unwrappedType;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean isList() {
        return this.list;
    }

    public String getDocMapKey() {
        return this.docMapKey;
    }

    public void setDocMapKey(String docMapKey) {
        this.docMapKey = docMapKey;
    }

    public boolean isPassThroughMap() {
        return this.passThroughMap;
    }

    public void setPassThroughMap(boolean passThroughMap) {
        this.passThroughMap = passThroughMap;
    }

    @Override
    public void accept(Writer writer, DocFormatter docFormatter) throws IOException {
        docFormatter.format(writer, this);
    }

    @Override
    public int compareTo(ConfigDocElement o) {
        return this.compare(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigDocKey that = (ConfigDocKey)o;
        return this.withinAMap == that.withinAMap && this.optional == that.optional && this.list == that.list && this.passThroughMap == that.passThroughMap && Objects.equals(this.type, that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.configDoc, that.configDoc) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.javaDocSiteLink, that.javaDocSiteLink) && Objects.equals(this.docMapKey, that.docMapKey) && this.configPhase == that.configPhase && Objects.equals(this.acceptedValues, that.acceptedValues);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.key, this.configDoc, this.withinAMap, this.defaultValue, this.javaDocSiteLink, this.docMapKey, this.configPhase, this.acceptedValues, this.optional, this.list, this.passThroughMap);
    }

    public String toString() {
        return "ConfigDocKey{type='" + this.type + '\'' + ", key='" + this.key + '\'' + ", configDoc='" + this.configDoc + '\'' + ", withinAMap=" + this.withinAMap + ", defaultValue='" + this.defaultValue + '\'' + ", javaDocSiteLink='" + this.javaDocSiteLink + '\'' + ", docMapKey='" + this.docMapKey + '\'' + ", configPhase=" + this.configPhase + ", acceptedValues=" + this.acceptedValues + ", optional=" + this.optional + ", list=" + this.list + ", passThroughMap=" + this.passThroughMap + '}';
    }
}

