/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ConfigDocWriter {
    private final DocFormatter summaryTableDocFormatter = new SummaryTableDocFormatter();

    public void writeExtensionConfigDocumentation(Map<String, List<ConfigDocItem>> extensionsConfigurations, boolean withSearchActivated) throws IOException {
        for (Map.Entry<String, List<ConfigDocItem>> entry : extensionsConfigurations.entrySet()) {
            List<ConfigDocItem> configDocItems = entry.getValue();
            String fileName = entry.getKey();
            ConfigDocWriter.sort(configDocItems);
            String anchorPrefix = fileName;
            if (fileName.endsWith(".adoc")) {
                anchorPrefix = anchorPrefix.substring(0, anchorPrefix.length() - 5);
            }
            this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve(fileName), anchorPrefix + "_", withSearchActivated, configDocItems);
        }
    }

    public void writeAllExtensionConfigDocumentation(List<ConfigDocItem> allItems) throws IOException {
        this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve("all-config.adoc"), "", true, allItems);
    }

    public static void sort(List<ConfigDocItem> configDocItems) {
        Collections.sort(configDocItems);
        for (ConfigDocItem configDocItem : configDocItems) {
            if (!configDocItem.isConfigSection()) continue;
            ConfigDocWriter.sort(configDocItem.getConfigDocSection().getConfigDocItems());
        }
    }

    private void generateDocumentation(Path targetPath, String initialAnchorPrefix, boolean activateSearch, List<ConfigDocItem> configDocItems) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, new OpenOption[0]);){
            this.summaryTableDocFormatter.format(writer, initialAnchorPrefix, activateSearch, configDocItems);
            boolean hasDuration = false;
            boolean hasMemory = false;
            for (ConfigDocItem item : configDocItems) {
                if (item.hasDurationInformationNote()) {
                    hasDuration = true;
                }
                if (!item.hasMemoryInformationNote()) continue;
                hasMemory = true;
            }
            if (hasDuration) {
                writer.append("\n[NOTE]\n[[duration-note-anchor]]\n.About the Duration format\n====\nThe format for durations uses the standard `java.time.Duration` format.\nYou can learn more about it in the link:https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html#parse-java.lang.CharSequence-[Duration#parse() javadoc].\n\nYou can also provide duration values starting with a number.\nIn this case, if the value consists only of a number, the converter treats the value as seconds.\nOtherwise, `PT` is implicitly prepended to the value to obtain a standard `java.time.Duration` format.\n====\n");
            }
            if (hasMemory) {
                writer.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
        }
    }
}

