/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import java.util.Comparator;

public enum ConfigPhase implements Comparable<ConfigPhase>
{
    RUN_TIME("The configuration is overridable at runtime", "icon:cogs[title=Overridable at runtime]", "RunTime"),
    BUILD_TIME("The configuration is not overridable at runtime", "icon:archive[title=Fixed at build time]", "BuildTime"),
    BUILD_AND_RUN_TIME_FIXED("The configuration is not overridable at runtime", "icon:archive[title=Fixed at build time]", "BuildTime");

    static final Comparator<ConfigPhase> COMPARATOR;
    private String description;
    private String illustration;
    private String configSuffix;

    private ConfigPhase(String description, String illustration, String configSuffix) {
        this.description = description;
        this.illustration = illustration;
        this.configSuffix = configSuffix;
    }

    public String toString() {
        return "ConfigPhase{description='" + this.description + '\'' + ", illustration='" + this.illustration + '\'' + ", configSuffix='" + this.configSuffix + '\'' + '}';
    }

    public String getIllustration() {
        return this.illustration;
    }

    public String getConfigSuffix() {
        return this.configSuffix;
    }

    static {
        COMPARATOR = new Comparator<ConfigPhase>(){

            @Override
            public int compare(ConfigPhase firstPhase, ConfigPhase secondPhase) {
                switch (firstPhase) {
                    case BUILD_TIME: {
                        switch (secondPhase) {
                            case BUILD_TIME: {
                                return 0;
                            }
                        }
                        return -1;
                    }
                    case BUILD_AND_RUN_TIME_FIXED: {
                        switch (secondPhase) {
                            case BUILD_TIME: {
                                return 1;
                            }
                            case BUILD_AND_RUN_TIME_FIXED: {
                                return 0;
                            }
                        }
                        return -1;
                    }
                    case RUN_TIME: {
                        switch (secondPhase) {
                            case RUN_TIME: {
                                return 0;
                            }
                        }
                        return 1;
                    }
                }
                return 0;
            }
        };
    }
}

