/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.annotation.processor.generate_doc.ConfigDocElement;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.io.IOException;
import java.io.Writer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ConfigDocItem
implements ConfigDocElement,
Comparable<ConfigDocItem> {
    private ConfigDocKey configDocKey;
    private ConfigDocSection configDocSection;

    public ConfigDocItem() {
    }

    public ConfigDocItem(ConfigDocSection configDocSection, ConfigDocKey configDocKey) {
        this.configDocSection = configDocSection;
        this.configDocKey = configDocKey;
    }

    public ConfigDocKey getConfigDocKey() {
        return this.configDocKey;
    }

    public void setConfigDocKey(ConfigDocKey configDocKey) {
        this.configDocKey = configDocKey;
    }

    public ConfigDocSection getConfigDocSection() {
        return this.configDocSection;
    }

    public void setConfigDocSection(ConfigDocSection configDocSection) {
        this.configDocSection = configDocSection;
    }

    @JsonIgnore
    boolean isConfigSection() {
        return this.configDocSection != null;
    }

    @JsonIgnore
    boolean isConfigKey() {
        return this.configDocKey != null;
    }

    public String toString() {
        return "ConfigDocItem{configDocSection=" + this.configDocSection + ", configDocKey=" + this.configDocKey + '}';
    }

    @Override
    public void accept(Writer writer, DocFormatter docFormatter) throws IOException {
        if (this.isConfigSection()) {
            this.configDocSection.accept(writer, docFormatter);
        } else if (this.isConfigKey()) {
            this.configDocKey.accept(writer, docFormatter);
        }
    }

    @Override
    @JsonIgnore
    public ConfigPhase getConfigPhase() {
        if (this.isConfigSection()) {
            return this.configDocSection.getConfigPhase();
        }
        if (this.isConfigKey()) {
            return this.configDocKey.getConfigPhase();
        }
        return null;
    }

    @Override
    @JsonIgnore
    public boolean isWithinAMap() {
        if (this.isConfigSection()) {
            return this.configDocSection.isWithinAMap();
        }
        if (this.isConfigKey()) {
            return this.configDocKey.isWithinAMap();
        }
        return false;
    }

    @JsonIgnore
    public boolean isWithinAConfigGroup() {
        if (this.isConfigSection()) {
            return true;
        }
        return this.isConfigKey() && this.configDocKey.isWithinAConfigGroup();
    }

    @Override
    public int compareTo(ConfigDocItem item) {
        if (this.isConfigSection() && item.isConfigKey()) {
            return 1;
        }
        if (this.isConfigKey() && item.isConfigSection()) {
            return -1;
        }
        return this.compare(item);
    }

    public boolean hasDurationInformationNote() {
        if (this.isConfigKey()) {
            return DocGeneratorUtil.hasDurationInformationNote(this.configDocKey);
        }
        if (this.isConfigSection()) {
            return this.configDocSection.hasDurationInformationNote();
        }
        return false;
    }

    public boolean hasMemoryInformationNote() {
        if (this.isConfigKey()) {
            return DocGeneratorUtil.hasMemoryInformationNote(this.configDocKey);
        }
        if (this.isConfigSection()) {
            return this.configDocSection.hasMemoryInformationNote();
        }
        return false;
    }
}

