/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

final class SummaryTableDocFormatter
implements DocFormatter {
    private static final String TABLE_CLOSING_TAG = "\n|===";
    public static final String SEARCHABLE_TABLE_CLASS = ".searchable";
    public static final String CONFIGURATION_TABLE_CLASS = ".configuration-reference";
    private static final String TABLE_ROW_FORMAT = "\n\na|%s [[%s]]`link:#%s[%s]`\n\n[.description]\n--\n%s\n--|%s %s\n|%s\n";
    private static final String SECTION_TITLE = "[[%s]]link:#%s[%s]";
    private static final String TABLE_SECTION_ROW_FORMAT = "\n\nh|%s\n%s\nh|Type\nh|Default";
    private static final String TABLE_HEADER_FORMAT = "[.configuration-legend]%s\n[%s, cols=\"80,.^10,.^10\"]\n|===";
    private String anchorPrefix = "";

    SummaryTableDocFormatter() {
    }

    @Override
    public void format(Writer writer, String initialAnchorPrefix, boolean activateSearch, List<ConfigDocItem> configDocItems) throws IOException {
        String searchableClass = activateSearch ? SEARCHABLE_TABLE_CLASS : "";
        String tableClasses = CONFIGURATION_TABLE_CLASS + searchableClass;
        String tableHeaders = String.format(TABLE_HEADER_FORMAT, Constants.CONFIG_PHASE_LEGEND, tableClasses);
        writer.append(tableHeaders);
        this.anchorPrefix = initialAnchorPrefix;
        if (configDocItems.isEmpty() || configDocItems.get(0).isConfigKey()) {
            String anchor = this.anchorPrefix + this.getAnchor("configuration");
            writer.append(String.format(TABLE_SECTION_ROW_FORMAT, String.format(SECTION_TITLE, anchor, anchor, "Configuration property"), ""));
        }
        for (ConfigDocItem configDocItem : configDocItems) {
            if (configDocItem.isConfigSection() && configDocItem.getConfigDocSection().isShowSection() && configDocItem.getConfigDocSection().getAnchorPrefix() != null) {
                this.anchorPrefix = configDocItem.getConfigDocSection().getAnchorPrefix() + "_";
            }
            configDocItem.accept(writer, this);
        }
        writer.append(TABLE_CLOSING_TAG);
    }

    @Override
    public void format(Writer writer, ConfigDocKey configDocKey) throws IOException {
        String typeContent = "";
        if (configDocKey.hasAcceptedValues()) {
            typeContent = DocGeneratorUtil.joinAcceptedValues(configDocKey.getAcceptedValues());
        } else if (configDocKey.hasType()) {
            typeContent = configDocKey.computeTypeSimpleName();
            String javaDocLink = configDocKey.getJavaDocSiteLink();
            if (!javaDocLink.isEmpty()) {
                typeContent = String.format("link:%s[%s]\n", javaDocLink, typeContent);
            }
        }
        if (configDocKey.isList()) {
            typeContent = "list of " + typeContent;
        }
        String doc = configDocKey.getConfigDoc();
        String typeDetail = DocGeneratorUtil.getTypeFormatInformationNote(configDocKey);
        String defaultValue = configDocKey.getDefaultValue();
        String required = configDocKey.isOptional() || !defaultValue.isEmpty() ? "" : "required icon:exclamation-circle[title=Configuration property is required]";
        String key = configDocKey.getKey();
        String configKeyAnchor = configDocKey.isPassThroughMap() ? this.getAnchor(key + "-" + configDocKey.getDocMapKey()) : this.getAnchor(key);
        String anchor = this.anchorPrefix + configKeyAnchor;
        writer.append(String.format(TABLE_ROW_FORMAT, configDocKey.getConfigPhase().getIllustration(), anchor, anchor, key, doc.replace("|", "\\|"), typeContent, typeDetail, defaultValue.isEmpty() ? required : String.format("`%s`", defaultValue)));
    }

    @Override
    public void format(Writer writer, ConfigDocSection configDocSection) throws IOException {
        if (configDocSection.isShowSection()) {
            String anchor = this.anchorPrefix + this.getAnchor(configDocSection.getName());
            String sectionTitle = String.format(SECTION_TITLE, anchor, anchor, configDocSection.getSectionDetailsTitle());
            String sectionRow = String.format(TABLE_SECTION_ROW_FORMAT, sectionTitle, configDocSection.isOptional() ? "This configuration section is optional" : "");
            writer.append(sectionRow);
        }
        for (ConfigDocItem configDocItem : configDocSection.getConfigDocItems()) {
            configDocItem.accept(writer, this);
        }
    }
}

