/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

final class JavaDocParser {
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);
    private static final Pattern REPLACE_WINDOWS_EOL = Pattern.compile("\r\n");
    private static final Pattern REPLACE_MACOS_EOL = Pattern.compile("\r");
    private static final String BACKTICK = "`";
    private static final String HASH = "#";
    private static final String STAR = "*";
    private static final String S_NODE = "s";
    private static final String UNDERSCORE = "_";
    private static final String NEW_LINE = "\n";
    private static final String LINK_NODE = "a";
    private static final String BOLD_NODE = "b";
    private static final String BIG_NODE = "big";
    private static final String CODE_NODE = "code";
    private static final String DEL_NODE = "del";
    private static final String ITALICS_NODE = "i";
    private static final String TEXT_NODE = "#text";
    private static final String UNDERLINE_NODE = "u";
    private static final String NEW_LINE_NODE = "br";
    private static final String PARAGRAPH_NODE = "p";
    private static final String SMALL_NODE = "small";
    private static final String EMPHASIS_NODE = "em";
    private static final String LIST_ITEM_NODE = "li";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String STRIKE_NODE = "strike";
    private static final String SUB_SCRIPT_NODE = "sub";
    private static final String ORDERED_LIST_NODE = "ol";
    private static final String SUPER_SCRIPT_NODE = "sup";
    private static final String UN_ORDERED_LIST_NODE = "ul";
    private static final String BIG_ASCIDOC_STYLE = "[.big]";
    private static final String LINK_ATTRIBUTE_FORMAT = "[%s]";
    private static final String SUB_SCRIPT_ASCIDOC_STYLE = "~";
    private static final String SUPER_SCRIPT_ASCIDOC_STYLE = "^";
    private static final String SMALL_ASCIDOC_STYLE = "[.small]";
    private static final String ORDERED_LIST_ITEM_ASCIDOC_STYLE = " . ";
    private static final String UNORDERED_LIST_ITEM_ASCIDOC_STYLE = " - ";
    private static final String UNDERLINE_ASCIDOC_STYLE = "[.underline]";
    private static final String LINE_THROUGH_ASCIDOC_STYLE = "[.line-through]";
    private final boolean inlineMacroMode;

    public JavaDocParser(boolean inlineMacroMode) {
        this.inlineMacroMode = inlineMacroMode;
    }

    public JavaDocParser() {
        this(false);
    }

    public String parseConfigDescription(String javadocComment) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            return "";
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        if (this.isAsciidoc(javadoc)) {
            return this.handleEolInAsciidoc(javadoc);
        }
        return this.htmlJavadocToAsciidoc(javadoc.getDescription());
    }

    public SectionHolder parseConfigSection(String javadocComment, int sectionLevel) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            return new SectionHolder("", "");
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        if (this.isAsciidoc(javadoc)) {
            String details = this.handleEolInAsciidoc(javadoc);
            int endOfTitleIndex = details.indexOf(46);
            String title = details.substring(0, endOfTitleIndex).replaceAll("^([^\\w])+", "").trim();
            return new SectionHolder(title, details);
        }
        return this.generateConfigSection(javadoc, sectionLevel);
    }

    private SectionHolder generateConfigSection(Javadoc javadoc, int sectionLevel) {
        String generatedAsciiDoc = this.htmlJavadocToAsciidoc(javadoc.getDescription());
        if (generatedAsciiDoc.isEmpty()) {
            return new SectionHolder("", "");
        }
        String beginSectionDetails = IntStream.rangeClosed(0, Math.max(0, sectionLevel)).mapToObj(x -> "=").collect(Collectors.joining()) + " ";
        int endOfTitleIndex = generatedAsciiDoc.indexOf(46);
        if (endOfTitleIndex == -1) {
            return new SectionHolder(generatedAsciiDoc.trim(), beginSectionDetails + generatedAsciiDoc);
        }
        String title = generatedAsciiDoc.substring(0, endOfTitleIndex).trim();
        String introduction = generatedAsciiDoc.substring(endOfTitleIndex + 1).trim();
        String details = beginSectionDetails + title + "\n\n" + introduction;
        return new SectionHolder(title, details.trim());
    }

    private String handleEolInAsciidoc(Javadoc javadoc) {
        String asciidoc = javadoc.getDescription().toText();
        asciidoc = REPLACE_WINDOWS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        asciidoc = REPLACE_MACOS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        return asciidoc;
    }

    private boolean isAsciidoc(Javadoc javadoc) {
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            if (!"asciidoclet".equals(blockTag.getTagName())) continue;
            return true;
        }
        return false;
    }

    private String htmlJavadocToAsciidoc(JavadocDescription javadocDescription) {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement javadocDescriptionElement : javadocDescription.getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: {
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    case LINK: 
                    case LINKPLAIN: {
                        if (content.startsWith(HASH)) {
                            content = DocGeneratorUtil.hyphenate(content.substring(1));
                        }
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    default: {
                        sb.append(content);
                        break;
                    }
                }
                continue;
            }
            this.appendHtml(sb, (Node)Jsoup.parseBodyFragment((String)javadocDescriptionElement.toText()));
        }
        return sb.toString().trim();
    }

    private void appendHtml(StringBuilder sb, Node node) {
        block38: for (Node childNode : node.childNodes()) {
            switch (childNode.nodeName()) {
                case "p": {
                    sb.append(NEW_LINE);
                    this.appendHtml(sb, childNode);
                    continue block38;
                }
                case "ol": 
                case "ul": {
                    this.appendHtml(sb, childNode);
                    continue block38;
                }
                case "li": {
                    String marker = childNode.parent().nodeName().equals(ORDERED_LIST_NODE) ? ORDERED_LIST_ITEM_ASCIDOC_STYLE : UNORDERED_LIST_ITEM_ASCIDOC_STYLE;
                    sb.append(NEW_LINE);
                    sb.append(marker);
                    this.appendHtml(sb, childNode);
                    continue block38;
                }
                case "a": {
                    String link = childNode.attr(HREF_ATTRIBUTE);
                    sb.append("link:");
                    sb.append(link);
                    StringBuilder caption = new StringBuilder();
                    this.appendHtml(caption, childNode);
                    sb.append(String.format(LINK_ATTRIBUTE_FORMAT, caption.toString().trim()));
                    continue block38;
                }
                case "code": {
                    sb.append(BACKTICK);
                    this.appendHtml(sb, childNode);
                    sb.append(BACKTICK);
                    continue block38;
                }
                case "b": 
                case "em": {
                    sb.append(STAR);
                    this.appendHtml(sb, childNode);
                    sb.append(STAR);
                    continue block38;
                }
                case "i": {
                    sb.append(UNDERSCORE);
                    this.appendHtml(sb, childNode);
                    sb.append(UNDERSCORE);
                    continue block38;
                }
                case "u": {
                    sb.append(UNDERLINE_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block38;
                }
                case "small": {
                    sb.append(SMALL_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block38;
                }
                case "big": {
                    sb.append(BIG_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block38;
                }
                case "sub": {
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    continue block38;
                }
                case "sup": {
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    continue block38;
                }
                case "del": 
                case "s": 
                case "strike": {
                    sb.append(LINE_THROUGH_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    continue block38;
                }
                case "br": {
                    sb.append(NEW_LINE);
                    continue block38;
                }
                case "#text": {
                    this.appendEscapedAsciiDoc(sb, ((TextNode)childNode).text());
                    continue block38;
                }
            }
            this.appendHtml(sb, childNode);
        }
    }

    private StringBuilder appendEscapedAsciiDoc(StringBuilder sb, String text) {
        boolean escaping = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case ']': {
                    if (this.inlineMacroMode) {
                        if (escaping) {
                            sb.append("++");
                            escaping = false;
                        }
                        sb.append("&#93;");
                        continue block5;
                    }
                }
                case '#': 
                case '*': 
                case '[': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    if (!escaping) {
                        sb.append("++");
                        escaping = true;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case '+': {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append("{plus}");
                    continue block5;
                }
                default: {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append(ch);
                }
            }
        }
        if (escaping) {
            sb.append("++");
        }
        return sb;
    }

    static class SectionHolder {
        final String title;
        final String details;

        public SectionHolder(String title, String details) {
            this.title = title;
            this.details = details;
        }
    }
}

