/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocGeneratedOutput;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public final class ConfigDocWriter {
    private final DocFormatter summaryTableDocFormatter = new SummaryTableDocFormatter();
    private static final String DECLARE_VAR = "\n:%s: %s\n";

    public void writeAllExtensionConfigDocumentation(ConfigDocGeneratedOutput output) throws IOException {
        this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve(output.getFileName()), output.getAnchorPrefix(), output.isSearchable(), output.getConfigDocItems(), output.getFileName());
    }

    private void generateDocumentation(Path targetPath, String initialAnchorPrefix, boolean activateSearch, List<ConfigDocItem> configDocItems, String fileName) throws IOException {
        if (configDocItems.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, new OpenOption[0]);){
            String fileNameWithoutExtension = fileName.substring(0, fileName.length() - ".adoc".length());
            writer.append(String.format(DECLARE_VAR, "summaryTableId", fileNameWithoutExtension));
            this.summaryTableDocFormatter.format(writer, initialAnchorPrefix, activateSearch, configDocItems);
            boolean hasDuration = false;
            boolean hasMemory = false;
            for (ConfigDocItem item : configDocItems) {
                if (item.hasDurationInformationNote()) {
                    hasDuration = true;
                }
                if (!item.hasMemoryInformationNote()) continue;
                hasMemory = true;
            }
            if (hasDuration) {
                writer.append(Constants.DURATION_FORMAT_NOTE);
            }
            if (hasMemory) {
                writer.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
        }
    }
}

