/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.FsMap;
import io.quarkus.annotation.processor.generate_doc.JavaDocParser;
import io.quarkus.annotation.processor.generate_doc.ScannedConfigDocsItemHolder;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class ConfigDocItemFinder {
    private static final String COMMA = ",";
    private static final String BACK_TICK = "`";
    private static final String NAMED_MAP_CONFIG_ITEM_FORMAT = ".\"%s\"";
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char"));
    private final JavaDocParser javaDocParser = new JavaDocParser();
    private final JavaDocParser enumJavaDocParser = new JavaDocParser(true);
    private final ScannedConfigDocsItemHolder holder = new ScannedConfigDocsItemHolder();
    private final Set<ConfigRootInfo> configRoots;
    private final Properties javaDocProperties;
    private final Map<String, TypeElement> configGroupQualifiedNameToTypeElementMap;
    private final FsMap allConfigurationGroups;
    private final FsMap allConfigurationRoots;
    private final boolean configMapping;

    public ConfigDocItemFinder(Set<ConfigRootInfo> configRoots, Map<String, TypeElement> configGroupQualifiedNameToTypeElementMap, Properties javaDocProperties, FsMap allConfigurationGroups, FsMap allConfigurationRoots, boolean configMapping) {
        this.configRoots = configRoots;
        this.configGroupQualifiedNameToTypeElementMap = configGroupQualifiedNameToTypeElementMap;
        this.javaDocProperties = javaDocProperties;
        this.allConfigurationGroups = allConfigurationGroups;
        this.allConfigurationRoots = allConfigurationRoots;
        this.configMapping = configMapping;
    }

    ScannedConfigDocsItemHolder findInMemoryConfigurationItems() throws IOException {
        for (Map.Entry<String, TypeElement> entry : this.configGroupQualifiedNameToTypeElementMap.entrySet()) {
            ConfigPhase buildTime = ConfigPhase.BUILD_TIME;
            List<ConfigDocItem> configDocItems = this.recursivelyFindConfigItems(entry.getValue(), "", "", buildTime, false, 1, false, this.configMapping);
            this.allConfigurationGroups.put(entry.getKey(), Constants.OBJECT_MAPPER.writeValueAsString(configDocItems));
        }
        for (ConfigRootInfo configRootInfo : this.configRoots) {
            boolean sectionLevel = false;
            TypeElement element = configRootInfo.getClazz();
            String rootName = configRootInfo.getName();
            ConfigPhase configPhase = configRootInfo.getConfigPhase();
            List<ConfigDocItem> configDocItems = this.recursivelyFindConfigItems(element, rootName, rootName, configPhase, false, 0, true, this.configMapping);
            this.holder.addConfigRootItems(configRootInfo, configDocItems);
            this.allConfigurationRoots.put(configRootInfo.getClazz().toString(), Constants.OBJECT_MAPPER.writeValueAsString(configDocItems));
        }
        return this.holder;
    }

    /*
     * WARNING - void declaration
     */
    private List<ConfigDocItem> recursivelyFindConfigItems(Element element, String rootName, String parentName, ConfigPhase configPhase, boolean withinAMap, int sectionLevel, boolean generateSeparateConfigGroupDocsFiles, boolean configMapping) throws JsonProcessingException {
        ArrayList<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
        TypeElement asTypeElement = (TypeElement)element;
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        superTypes.add(asTypeElement.getSuperclass());
        superTypes.addAll(asTypeElement.getInterfaces());
        for (TypeMirror typeMirror : superTypes) {
            List<ConfigDocItem> superTypeConfigItems;
            if (typeMirror.getKind() == TypeKind.NONE || typeMirror.toString().equals(Object.class.getName())) continue;
            String key = typeMirror.toString();
            String rawConfigItems = this.allConfigurationGroups.get(key);
            if (rawConfigItems == null) {
                rawConfigItems = this.allConfigurationRoots.get(key);
            }
            if (rawConfigItems == null) {
                Element superElement = ((DeclaredType)typeMirror).asElement();
                superTypeConfigItems = this.recursivelyFindConfigItems(superElement, rootName, parentName, configPhase, withinAMap, sectionLevel, generateSeparateConfigGroupDocsFiles, configMapping);
            } else {
                superTypeConfigItems = (List<ConfigDocItem>)Constants.OBJECT_MAPPER.readValue(rawConfigItems, Constants.LIST_OF_CONFIG_ITEMS_TYPE_REF);
            }
            configDocItems.addAll((Collection<ConfigDocItem>)superTypeConfigItems);
        }
        for (Element element2 : element.getEnclosedElements()) {
            void var32_41;
            TypeMirror typeMirror;
            String string;
            String hyphenatedFieldName;
            boolean isStaticField;
            if (!this.shouldProcessElement(element2, configMapping) || (isStaticField = element2.getModifiers().stream().anyMatch(Modifier.STATIC::equals))) continue;
            Object name = null;
            String defaultValue = "<<no default>>";
            String defaultValueDoc = "";
            List<String> acceptedValues = null;
            TypeElement clazz = (TypeElement)element;
            String fieldName = element2.getSimpleName().toString();
            String javaDocKey = clazz.getQualifiedName().toString() + "." + fieldName;
            List<? extends AnnotationMirror> annotationMirrors = element2.getAnnotationMirrors();
            String rawJavaDoc = this.javaDocProperties.getProperty(javaDocKey);
            boolean useHyphenateEnumValue = true;
            String configDocMapKey = hyphenatedFieldName = DocGeneratorUtil.hyphenate(fieldName);
            boolean unnamedMapKey = false;
            boolean isDeprecated = false;
            boolean generateDocumentation = true;
            ConfigDocSection configSection = new ConfigDocSection();
            configSection.setTopLevelGrouping(rootName);
            configSection.setWithinAMap(withinAMap);
            configSection.setConfigPhase(configPhase);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (annotationName.equals(Deprecated.class.getName())) {
                    isDeprecated = true;
                    break;
                }
                if (annotationName.equals("io.quarkus.runtime.annotations.ConfigItem") || annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey")) {
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String key = entry.getKey().toString();
                        Object value = entry.getValue().getValue();
                        if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey") && "value()".equals(key)) {
                            configDocMapKey = value.toString();
                            continue;
                        }
                        if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigItem")) continue;
                        if ("name()".equals(key)) {
                            switch (value.toString()) {
                                case "<<hyphenated element name>>": {
                                    name = parentName + "." + hyphenatedFieldName;
                                    break;
                                }
                                case "<<parent>>": {
                                    name = parentName;
                                    break;
                                }
                                default: {
                                    name = parentName + "." + value;
                                    break;
                                }
                            }
                            continue;
                        }
                        if ("defaultValue()".equals(key)) {
                            defaultValue = value.toString();
                            continue;
                        }
                        if ("defaultValueDocumentation()".equals(key)) {
                            defaultValueDoc = value.toString();
                            continue;
                        }
                        if (!"generateDocumentation()".equals(key)) continue;
                        generateDocumentation = (Boolean)value;
                    }
                } else if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocSection")) {
                    JavaDocParser.SectionHolder sectionHolder = this.javaDocParser.parseConfigSection(rawJavaDoc, sectionLevel);
                    configSection.setShowSection(true);
                    configSection.setSectionDetails(sectionHolder.details);
                    configSection.setSectionDetailsTitle(sectionHolder.title);
                    configSection.setName(parentName + "." + hyphenatedFieldName);
                } else if (annotationName.equals("io.quarkus.runtime.annotations.DefaultConverter") || annotationName.equals("io.quarkus.runtime.annotations.ConvertWith")) {
                    useHyphenateEnumValue = false;
                }
                if (annotationName.equals("io.smallrye.config.WithName")) {
                    name = parentName + "." + annotationMirror.getElementValues().values().iterator().next().getValue();
                    continue;
                }
                if (annotationName.equals("io.smallrye.config.WithParentName")) {
                    name = parentName;
                    continue;
                }
                if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocDefault")) {
                    defaultValueDoc = annotationMirror.getElementValues().values().iterator().next().getValue().toString();
                    continue;
                }
                if (annotationName.equals("io.smallrye.config.WithDefault")) {
                    defaultValue = annotationMirror.getElementValues().values().isEmpty() ? null : annotationMirror.getElementValues().values().iterator().next().getValue().toString();
                    continue;
                }
                if (annotationName.equals("io.smallrye.config.WithUnnamedKey")) {
                    unnamedMapKey = true;
                    continue;
                }
                if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocIgnore")) continue;
                generateDocumentation = false;
            }
            if (isDeprecated || !generateDocumentation) continue;
            if (name == null) {
                name = parentName + "." + hyphenatedFieldName;
            }
            if ("<<no default>>".equals(defaultValue)) {
                defaultValue = "";
            }
            if (this.isConfigGroup(string = this.getType(typeMirror = this.unwrapTypeMirror(element2.asType())))) {
                List<ConfigDocItem> groupConfigItems = this.readConfigGroupItems(configPhase, rootName, (String)name, Collections.emptyList(), string, configSection, withinAMap, generateSeparateConfigGroupDocsFiles, configMapping);
                DocGeneratorUtil.appendConfigItemsIntoExistingOnes(configDocItems, groupConfigItems);
                continue;
            }
            ConfigDocKey configDocKey = new ConfigDocKey();
            configDocKey.setWithinAMap(withinAMap);
            boolean list = false;
            boolean optional = false;
            if (!typeMirror.getKind().isPrimitive()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                Name qualifiedName = typeElement.getQualifiedName();
                optional = qualifiedName.toString().startsWith(Optional.class.getName()) || qualifiedName.contentEquals(Map.class.getName());
                list = qualifiedName.contentEquals(List.class.getName()) || qualifiedName.contentEquals(Set.class.getName());
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    if (typeArguments.size() == 2) {
                        List<CallSite> additionalNames;
                        String string2 = this.getType(typeArguments.get(1));
                        if (unnamedMapKey) {
                            additionalNames = List.of((String)name + String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, configDocMapKey));
                        } else {
                            name = (String)name + String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, configDocMapKey);
                            additionalNames = Collections.emptyList();
                        }
                        if (this.isConfigGroup(string2)) {
                            List<ConfigDocItem> groupConfigItems = this.readConfigGroupItems(configPhase, rootName, (String)name, additionalNames, string2, configSection, true, generateSeparateConfigGroupDocsFiles, configMapping);
                            DocGeneratorUtil.appendConfigItemsIntoExistingOnes(configDocItems, groupConfigItems);
                            continue;
                        }
                        configDocKey.setWithinAMap(true);
                    } else {
                        TypeMirror realTypeMirror = typeArguments.get(0);
                        String typeInString = realTypeMirror.toString();
                        if (optional) {
                            if (this.isConfigGroup(typeInString)) {
                                if (!configSection.isShowSection()) {
                                    JavaDocParser.SectionHolder sectionHolder = this.javaDocParser.parseConfigSection(rawJavaDoc, sectionLevel);
                                    configSection.setSectionDetails(sectionHolder.details);
                                    configSection.setSectionDetailsTitle(sectionHolder.title);
                                    configSection.setName(parentName + "." + hyphenatedFieldName);
                                    configSection.setShowSection(true);
                                }
                                configSection.setOptional(true);
                                List<ConfigDocItem> groupConfigItems = this.readConfigGroupItems(configPhase, rootName, (String)name, Collections.emptyList(), typeInString, configSection, withinAMap, generateSeparateConfigGroupDocsFiles, configMapping);
                                DocGeneratorUtil.appendConfigItemsIntoExistingOnes(configDocItems, groupConfigItems);
                                continue;
                            }
                            if (typeInString.startsWith(List.class.getName()) || typeInString.startsWith(Set.class.getName()) || realTypeMirror.getKind() == TypeKind.ARRAY) {
                                list = true;
                                DeclaredType declaredRealType = (DeclaredType)typeMirror;
                                typeArguments = declaredRealType.getTypeArguments();
                                if (!typeArguments.isEmpty()) {
                                    realTypeMirror = typeArguments.get(0);
                                }
                            }
                        }
                        String string3 = this.simpleTypeToString(realTypeMirror);
                        if (this.isEnumType(realTypeMirror)) {
                            if (defaultValueDoc.isBlank()) {
                                if (useHyphenateEnumValue) {
                                    defaultValue = Arrays.stream(defaultValue.split(COMMA)).map(defaultEnumValue -> DocGeneratorUtil.hyphenateEnumValue(defaultEnumValue.trim())).collect(Collectors.joining(COMMA));
                                }
                            } else {
                                defaultValue = defaultValueDoc;
                            }
                            acceptedValues = this.extractEnumValues(realTypeMirror, useHyphenateEnumValue, clazz.getQualifiedName().toString());
                            configDocKey.setEnum(true);
                        } else if (!defaultValueDoc.isBlank()) {
                            defaultValue = defaultValueDoc;
                        }
                    }
                } else {
                    String string4 = this.simpleTypeToString(declaredType);
                    if (defaultValueDoc.isBlank()) {
                        if (this.isEnumType(declaredType)) {
                            defaultValue = DocGeneratorUtil.hyphenateEnumValue(defaultValue);
                            acceptedValues = this.extractEnumValues(declaredType, useHyphenateEnumValue, clazz.getQualifiedName().toString());
                            configDocKey.setEnum(true);
                        } else if (this.isDurationType(declaredType) && !defaultValue.isEmpty()) {
                            defaultValue = DocGeneratorUtil.normalizeDurationValue(defaultValue);
                        }
                    } else {
                        defaultValue = defaultValueDoc;
                    }
                }
            }
            configDocKey.setKey((String)name);
            configDocKey.setAdditionalKeys(Collections.emptyList());
            configDocKey.setType((String)var32_41);
            configDocKey.setList(list);
            configDocKey.setOptional(optional);
            configDocKey.setWithinAConfigGroup(sectionLevel > 0);
            configDocKey.setTopLevelGrouping(rootName);
            configDocKey.setConfigPhase(configPhase);
            configDocKey.setDefaultValue(defaultValue);
            configDocKey.setDocMapKey(configDocMapKey);
            this.javaDocParser.parseConfigDescription(rawJavaDoc, configDocKey::setConfigDoc, configDocKey::setSince);
            configDocKey.setEnvironmentVariable(DocGeneratorUtil.toEnvVarName((String)name));
            configDocKey.setAcceptedValues(acceptedValues);
            configDocKey.setJavaDocSiteLink(DocGeneratorUtil.getJavaDocSiteLink((String)var32_41));
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocKey(configDocKey);
            ConfigDocItem parent = null;
            for (ConfigDocItem docItem : configDocItems) {
                if (docItem.getConfigDocKey() == null || !docItem.getConfigDocKey().getKey().equals(configDocKey.getKey())) continue;
                parent = docItem;
                break;
            }
            if (parent != null) {
                configDocItems.remove(parent);
            }
            configDocItems.add(configDocItem);
        }
        return configDocItems;
    }

    private TypeMirror unwrapTypeMirror(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            return typeMirror;
        }
        if (typeMirror instanceof ExecutableType) {
            ExecutableType executableType = (ExecutableType)typeMirror;
            return executableType.getReturnType();
        }
        return typeMirror;
    }

    private String getType(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return typeMirror.toString();
    }

    private boolean isConfigGroup(String type) {
        if (type.startsWith("java.") || PRIMITIVE_TYPES.contains(type)) {
            return false;
        }
        return this.configGroupQualifiedNameToTypeElementMap.containsKey(type) || this.allConfigurationGroups.hasKey(type);
    }

    private boolean shouldProcessElement(Element enclosedElement, boolean configMapping) {
        if (enclosedElement.getKind().isField()) {
            return true;
        }
        if (!configMapping && enclosedElement.getKind() == ElementKind.METHOD) {
            return false;
        }
        if (enclosedElement.getKind().equals((Object)ElementKind.METHOD)) {
            ExecutableElement method = (ExecutableElement)enclosedElement;
            if (method.getSimpleName().contentEquals("toString") && method.getParameters().size() == 0) {
                return false;
            }
            Element enclosingElement = enclosedElement.getEnclosingElement();
            return enclosingElement.getModifiers().contains((Object)Modifier.ABSTRACT) && enclosedElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        return false;
    }

    private String simpleTypeToString(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return this.simpleTypeToString(((ArrayType)typeMirror).getComponentType());
        }
        String knownGenericType = DocGeneratorUtil.getKnownGenericType((DeclaredType)typeMirror);
        if (knownGenericType != null) {
            return knownGenericType;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        if (!typeArguments.isEmpty()) {
            return this.simpleTypeToString(typeArguments.get(0));
        }
        return this.getType(typeMirror);
    }

    private List<String> extractEnumValues(TypeMirror realTypeMirror, boolean useHyphenatedEnumValue, String javaDocKey) {
        Element declaredTypeElement = ((DeclaredType)realTypeMirror).asElement();
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Element element : declaredTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String enumValue = element.getSimpleName().toString();
            String constantJavaDocKey = javaDocKey + "." + enumValue;
            String rawJavaDoc = this.javaDocProperties.getProperty(constantJavaDocKey);
            String explicitEnumValueName = this.extractEnumValueName(element);
            if (explicitEnumValueName != null) {
                enumValue = explicitEnumValueName;
            } else {
                String string = enumValue = useHyphenatedEnumValue ? DocGeneratorUtil.hyphenateEnumValue(enumValue) : enumValue;
            }
            if (rawJavaDoc != null && !rawJavaDoc.isBlank()) {
                String javaDoc = this.enumJavaDocParser.parseConfigDescription(rawJavaDoc);
                acceptedValues.add(String.format("tooltip:%s[%s]", enumValue, javaDoc.replace("<p>", "").replace("</p>", "").replace("\n", " ")));
                continue;
            }
            acceptedValues.add(BACK_TICK + enumValue + BACK_TICK);
        }
        return acceptedValues;
    }

    private String extractEnumValueName(Element enumField) {
        for (AnnotationMirror annotationMirror : enumField.getAnnotationMirrors()) {
            String annotationName = annotationMirror.getAnnotationType().toString();
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocEnumValue")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue().getValue();
                if (!"value()".equals(key)) continue;
                return value.toString();
            }
        }
        return null;
    }

    private boolean isEnumType(TypeMirror realTypeMirror) {
        return realTypeMirror instanceof DeclaredType && ((DeclaredType)realTypeMirror).asElement().getKind() == ElementKind.ENUM;
    }

    private boolean isDurationType(TypeMirror realTypeMirror) {
        return realTypeMirror.toString().equals(Duration.class.getName());
    }

    private List<ConfigDocItem> readConfigGroupItems(ConfigPhase configPhase, String topLevelRootName, String parentName, List<String> additionalNames, String configGroup, ConfigDocSection configSection, boolean withinAMap, boolean generateSeparateConfigGroupDocs, boolean configMapping) throws JsonProcessingException {
        List<ConfigDocItem> groupConfigItems;
        configSection.setConfigGroupType(configGroup);
        if (configSection.getSectionDetailsTitle() == null) {
            configSection.setSectionDetailsTitle(parentName);
        }
        if (configSection.getName() == null) {
            configSection.setName("");
        }
        ArrayList<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
        String property = this.allConfigurationGroups.get(configGroup);
        if (property != null) {
            groupConfigItems = (List<ConfigDocItem>)Constants.OBJECT_MAPPER.readValue(property, Constants.LIST_OF_CONFIG_ITEMS_TYPE_REF);
        } else {
            TypeElement configGroupTypeElement = this.configGroupQualifiedNameToTypeElementMap.get(configGroup);
            groupConfigItems = this.recursivelyFindConfigItems(configGroupTypeElement, "", "", configPhase, false, 1, generateSeparateConfigGroupDocs, configMapping);
            this.allConfigurationGroups.put(configGroup, Constants.OBJECT_MAPPER.writeValueAsString(groupConfigItems));
        }
        groupConfigItems = this.decorateGroupItems(groupConfigItems, configPhase, topLevelRootName, parentName, additionalNames, withinAMap, generateSeparateConfigGroupDocs);
        if (configSection.isShowSection() || !generateSeparateConfigGroupDocs) {
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocSection(configSection);
            configDocItems.add(configDocItem);
            configSection.addConfigDocItems(groupConfigItems);
        } else {
            configDocItems.addAll(groupConfigItems);
        }
        if (generateSeparateConfigGroupDocs) {
            this.addConfigGroupItemToHolder(configDocItems, configGroup);
        }
        return configDocItems;
    }

    private List<ConfigDocItem> decorateGroupItems(List<ConfigDocItem> groupConfigItems, ConfigPhase configPhase, String topLevelRootName, String parentName, List<String> additionalNames, boolean withinAMap, boolean generateSeparateConfigGroupDocs) {
        ArrayList<ConfigDocItem> decoratedItems = new ArrayList<ConfigDocItem>();
        for (ConfigDocItem configDocItem : groupConfigItems) {
            if (configDocItem.isConfigKey()) {
                ConfigDocKey configDocKey = configDocItem.getConfigDocKey();
                configDocKey.setConfigPhase(configPhase);
                configDocKey.setWithinAMap(configDocKey.isWithinAMap() || withinAMap);
                configDocKey.setWithinAConfigGroup(true);
                configDocKey.setTopLevelGrouping(topLevelRootName);
                ArrayList<String> additionalKeys = new ArrayList<String>();
                for (String key : configDocKey.getAdditionalKeys()) {
                    additionalKeys.add(parentName + key);
                    for (String name : additionalNames) {
                        additionalKeys.add(name + key);
                    }
                }
                additionalKeys.addAll(additionalNames.stream().map(k -> k + configDocKey.getKey()).collect(Collectors.toList()));
                configDocKey.setAdditionalKeys(additionalKeys);
                configDocKey.setKey(parentName + configDocKey.getKey());
                configDocKey.setEnvironmentVariable(DocGeneratorUtil.toEnvVarName(parentName) + configDocKey.getEnvironmentVariable());
                decoratedItems.add(configDocItem);
                continue;
            }
            ConfigDocSection section = configDocItem.getConfigDocSection();
            section.setConfigPhase(configPhase);
            section.setTopLevelGrouping(topLevelRootName);
            section.setWithinAMap(section.isWithinAMap() || withinAMap);
            section.setName(parentName + section.getName());
            List<ConfigDocItem> configDocItems = this.decorateGroupItems(section.getConfigDocItems(), configPhase, topLevelRootName, parentName, additionalNames, section.isWithinAMap(), generateSeparateConfigGroupDocs);
            String configGroupType = section.getConfigGroupType();
            if (generateSeparateConfigGroupDocs) {
                this.addConfigGroupItemToHolder(configDocItems, configGroupType);
            }
            if (section.isShowSection()) {
                decoratedItems.add(configDocItem);
                continue;
            }
            decoratedItems.addAll(configDocItems);
        }
        return decoratedItems;
    }

    private void addConfigGroupItemToHolder(List<ConfigDocItem> configDocItems, String configGroupType) {
        List<ConfigDocItem> previousConfigGroupConfigItems = this.holder.getConfigGroupConfigItems().get(configGroupType);
        if (previousConfigGroupConfigItems == null) {
            this.holder.addConfigGroupItems(configGroupType, configDocItems);
        } else {
            previousConfigGroupConfigItems.addAll(configDocItems);
        }
    }
}

