/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.util;

import io.quarkus.annotation.processor.documentation.config.util.JacksonMappers;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class FilerUtil {
    private final ProcessingEnvironment processingEnv;

    FilerUtil(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public void write(String filePath, Set<String> set) {
        if (set.isEmpty()) {
            return;
        }
        try {
            FileObject listResource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filePath.toString(), new Element[0]);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(listResource.openOutputStream(), StandardCharsets.UTF_8));){
                for (String className : set) {
                    writer.write(className);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write " + filePath + ": " + e);
            return;
        }
    }

    public void write(String filePath, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        try {
            FileObject propertiesResource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filePath.toString(), new Element[0]);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(propertiesResource.openOutputStream(), StandardCharsets.UTF_8));){
                PropertyUtils.store((Properties)properties, (Writer)writer);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write " + filePath + ": " + e);
            return;
        }
    }

    public void writeJson(String filePath, Object value) {
        if (value == null) {
            return;
        }
        try {
            FileObject jsonResource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filePath.toString(), new Element[0]);
            try (OutputStream os = jsonResource.openOutputStream();){
                JacksonMappers.jsonObjectWriter().writeValue(os, value);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write " + filePath + ": " + e);
            return;
        }
    }

    public Path writeModel(Path filePath, Object value) {
        Path yamlModelPath = this.getTargetPath().resolve(filePath);
        try {
            Files.createDirectories(yamlModelPath.getParent(), new FileAttribute[0]);
            JacksonMappers.yamlObjectWriter().writeValue(yamlModelPath.toFile(), value);
            return yamlModelPath;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write the model to: " + yamlModelPath, e);
        }
    }

    public Path getTargetPath() {
        try {
            FileObject dummyFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "dummy");
            return Paths.get(dummyFile.toUri()).getParent().getParent();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to determine the path of target/" + e);
            throw new UncheckedIOException(e);
        }
    }

    public Optional<Path> getPomPath() {
        try {
            Path pomPath = Paths.get(this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "dummy").toUri()).getParent().getParent().getParent().resolve("pom.xml");
            if (!Files.isReadable(pomPath)) {
                return Optional.empty();
            }
            return Optional.of(pomPath.toAbsolutePath());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<Map<String, Object>> getExtensionMetadata() {
        Optional<Map<String, Object>> optional;
        block9: {
            String extensionMetadataDescriptor = "META-INF/quarkus-extension.yaml";
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", extensionMetadataDescriptor);
            if (fileObject == null) {
                return Optional.empty();
            }
            InputStream is = fileObject.openInputStream();
            try {
                String yamlMetadata = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                Map extensionMetadata = (Map)JacksonMappers.yamlObjectReader().readValue(yamlMetadata, Map.class);
                optional = Optional.of(extensionMetadata);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to read extension metadata file: " + extensionMetadataDescriptor + " because of " + e.getMessage());
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }
}

