/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.resolver;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.EnumDefinition;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.model.ResolvedModel;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import io.quarkus.annotation.processor.documentation.config.util.JavadocUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Strings;
import io.quarkus.annotation.processor.util.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ConfigResolver {
    private final Config config;
    private final Utils utils;
    private final ConfigCollector configCollector;

    public ConfigResolver(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    public JavadocElements resolveJavadoc() {
        return new JavadocElements(this.config.getExtension(), this.configCollector.getJavadocElements());
    }

    public ResolvedModel resolveModel() {
        ArrayList<ConfigRoot> configRoots = new ArrayList<ConfigRoot>();
        for (DiscoveryConfigRoot discoveryConfigRoot : this.configCollector.getConfigRoots()) {
            ConfigRoot configRoot = new ConfigRoot(discoveryConfigRoot.getExtension(), discoveryConfigRoot.getPrefix(), discoveryConfigRoot.getOverriddenDocPrefix(), discoveryConfigRoot.getOverriddenDocFileName());
            HashMap<String, ConfigSection> existingRootConfigSections = new HashMap<String, ConfigSection>();
            configRoot.addQualifiedName(discoveryConfigRoot.getQualifiedName());
            ResolutionContext context = new ResolutionContext(configRoot.getPrefix(), new ArrayList<String>(), discoveryConfigRoot, configRoot, 0, false, false, false);
            for (DiscoveryConfigProperty discoveryConfigProperty : discoveryConfigRoot.getProperties().values()) {
                this.resolveProperty(configRoot, existingRootConfigSections, discoveryConfigRoot.getPhase(), context, discoveryConfigProperty);
            }
            configRoots.add(configRoot);
        }
        return new ResolvedModel(configRoots);
    }

    private void resolveProperty(ConfigRoot configRoot, Map<String, ConfigSection> existingRootConfigSections, ConfigPhase phase, ResolutionContext context, DiscoveryConfigProperty discoveryConfigProperty) {
        String propertyPath = ConfigResolver.appendPath(context.getPath(), discoveryConfigProperty.getPath());
        List additionalPaths = context.getAdditionalPaths().stream().map(p -> ConfigResolver.appendPath(p, discoveryConfigProperty.getPath())).collect(Collectors.toCollection(ArrayList::new));
        boolean deprecated = context.isDeprecated() || discoveryConfigProperty.isDeprecated();
        String typeQualifiedName = discoveryConfigProperty.getType().qualifiedName();
        if (this.configCollector.isResolvedConfigGroup(typeQualifiedName)) {
            ResolutionContext configGroupContext;
            boolean isWithMapWithUnnamedKey;
            DiscoveryConfigGroup discoveryConfigGroup = this.configCollector.getResolvedConfigGroup(typeQualifiedName);
            Object potentiallyMappedPath = propertyPath;
            if (discoveryConfigProperty.getType().isMap()) {
                if (discoveryConfigProperty.isUnnamedMapKey()) {
                    ListIterator<CallSite> additionalPathsIterator = additionalPaths.listIterator();
                    additionalPathsIterator.add((CallSite)((Object)(propertyPath + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey()))));
                    while (additionalPathsIterator.hasNext()) {
                        additionalPathsIterator.add((CallSite)((Object)((String)additionalPathsIterator.next() + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey()))));
                    }
                } else {
                    potentiallyMappedPath = (String)potentiallyMappedPath + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey());
                    additionalPaths = additionalPaths.stream().map(p -> p + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey())).collect(Collectors.toCollection(ArrayList::new));
                }
            }
            boolean isWithinMap = context.isWithinMap() || discoveryConfigProperty.getType().isMap();
            boolean bl = isWithMapWithUnnamedKey = context.isWithinMapWithUnnamedKey() || discoveryConfigProperty.isUnnamedMapKey();
            if (discoveryConfigProperty.isSection()) {
                Object configSection = existingRootConfigSections.get(propertyPath);
                if (configSection != null) {
                    ((ConfigSection)configSection).appendState(discoveryConfigProperty.isSectionGenerated(), deprecated);
                } else {
                    configSection = new ConfigSection(discoveryConfigProperty.getSourceClass(), discoveryConfigProperty.getSourceName(), propertyPath, typeQualifiedName, context.getSectionLevel(), discoveryConfigProperty.isSectionGenerated(), deprecated);
                    context.getItemCollection().addItem((AbstractConfigItem)configSection);
                    existingRootConfigSections.put(propertyPath, (ConfigSection)configSection);
                }
                configGroupContext = new ResolutionContext((String)potentiallyMappedPath, additionalPaths, discoveryConfigGroup, (ConfigItemCollection)configSection, context.getSectionLevel() + 1, isWithinMap, isWithMapWithUnnamedKey, deprecated);
            } else {
                configGroupContext = new ResolutionContext((String)potentiallyMappedPath, additionalPaths, discoveryConfigGroup, context.getItemCollection(), context.getSectionLevel(), isWithinMap, isWithMapWithUnnamedKey, deprecated);
            }
            for (DiscoveryConfigProperty configGroupProperty : discoveryConfigGroup.getProperties().values()) {
                this.resolveProperty(configRoot, existingRootConfigSections, phase, configGroupContext, configGroupProperty);
            }
        } else {
            String typeBinaryName = discoveryConfigProperty.getType().binaryName();
            String typeSimplifiedName = discoveryConfigProperty.getType().simplifiedName();
            boolean hyphenateEnumValues = discoveryConfigProperty.isEnforceHyphenateEnumValue() || !discoveryConfigProperty.isConverted();
            String defaultValue = ConfigResolver.getDefaultValue(discoveryConfigProperty.getDefaultValue(), discoveryConfigProperty.getDefaultValueForDoc(), discoveryConfigProperty.getType(), hyphenateEnumValues);
            EnumAcceptedValues enumAcceptedValues = null;
            if (discoveryConfigProperty.getType().isEnum()) {
                EnumDefinition enumDefinition = this.configCollector.getResolvedEnum(typeQualifiedName);
                Map localAcceptedValues = enumDefinition.constants().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new EnumAcceptedValues.EnumAcceptedValue(((EnumDefinition.EnumConstant)e.getValue()).hasExplicitValue() ? ((EnumDefinition.EnumConstant)e.getValue()).explicitValue() : (hyphenateEnumValues ? ConfigNamingUtil.hyphenateEnumValue((String)e.getKey()) : (String)e.getKey())), (x, y) -> y, LinkedHashMap::new));
                enumAcceptedValues = new EnumAcceptedValues(enumDefinition.qualifiedName(), localAcceptedValues);
            }
            Object potentiallyMappedPath = propertyPath;
            boolean optional = discoveryConfigProperty.getType().isOptional();
            if (discoveryConfigProperty.getType().isMap()) {
                optional = true;
                typeQualifiedName = discoveryConfigProperty.getType().wrapperType().toString();
                typeSimplifiedName = this.utils.element().simplifyGenericType(discoveryConfigProperty.getType().wrapperType());
                potentiallyMappedPath = (String)potentiallyMappedPath + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey());
                additionalPaths = additionalPaths.stream().map(p -> p + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey())).collect(Collectors.toCollection(ArrayList::new));
            } else if (discoveryConfigProperty.getType().isList()) {
                typeQualifiedName = discoveryConfigProperty.getType().wrapperType().toString();
            }
            ConfigProperty configProperty = new ConfigProperty(phase, discoveryConfigProperty.getSourceClass(), discoveryConfigProperty.getSourceName(), (String)potentiallyMappedPath, additionalPaths, ConfigNamingUtil.toEnvVarName((String)potentiallyMappedPath), typeQualifiedName, typeSimplifiedName, discoveryConfigProperty.getType().isMap(), discoveryConfigProperty.getType().isList(), optional, discoveryConfigProperty.getMapKey(), discoveryConfigProperty.isUnnamedMapKey(), context.isWithinMap(), discoveryConfigProperty.isConverted(), discoveryConfigProperty.getType().isEnum(), enumAcceptedValues, defaultValue, JavadocUtil.getJavadocSiteLink(typeBinaryName), deprecated);
            context.getItemCollection().addItem(configProperty);
        }
    }

    public static String getDefaultValue(String defaultValue, String defaultValueForDoc, ResolvedType type, boolean hyphenateEnumValues) {
        if (!Strings.isBlank(defaultValueForDoc)) {
            return defaultValueForDoc;
        }
        if (defaultValue == null) {
            return null;
        }
        if (type.isEnum() && hyphenateEnumValues) {
            if (type.isList()) {
                return Arrays.stream(defaultValue.split(",")).map(v -> ConfigNamingUtil.hyphenateEnumValue(v.trim())).collect(Collectors.joining(","));
            }
            return ConfigNamingUtil.hyphenateEnumValue(defaultValue.trim());
        }
        return defaultValue;
    }

    public static String getType(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return typeMirror.toString();
    }

    public static String appendPath(String parentPath, String path) {
        return "<<parent>>".equals(path) ? parentPath : parentPath + "." + path;
    }

    private static class ResolutionContext {
        private final String path;
        private final List<String> additionalPaths;
        private final DiscoveryRootElement discoveryRootElement;
        private final ConfigItemCollection itemCollection;
        private final int sectionLevel;
        private final boolean withinMap;
        private final boolean withinMapWithUnnamedKey;
        private final boolean deprecated;

        private ResolutionContext(String path, List<String> additionalPaths, DiscoveryRootElement discoveryRootElement, ConfigItemCollection itemCollection, int sectionLevel, boolean withinMap, boolean withinMapWithUnnamedKey, boolean deprecated) {
            this.path = path;
            this.additionalPaths = additionalPaths;
            this.discoveryRootElement = discoveryRootElement;
            this.itemCollection = itemCollection;
            this.withinMap = withinMap;
            this.withinMapWithUnnamedKey = withinMapWithUnnamedKey;
            this.deprecated = deprecated;
            this.sectionLevel = sectionLevel;
        }

        public String getPath() {
            return this.path;
        }

        public List<String> getAdditionalPaths() {
            return this.additionalPaths;
        }

        public DiscoveryRootElement getDiscoveryRootElement() {
            return this.discoveryRootElement;
        }

        public ConfigItemCollection getItemCollection() {
            return this.itemCollection;
        }

        public int getSectionLevel() {
            return this.sectionLevel;
        }

        public boolean isWithinMap() {
            return this.withinMap;
        }

        public boolean isWithinMapWithUnnamedKey() {
            return this.withinMapWithUnnamedKey;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

