/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadoc;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadocSection;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.formatter.JavadocToAsciidocTransformer;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.scanner.AbstractJavadocConfigListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class JavadocLegacyConfigRootListener
extends AbstractJavadocConfigListener {
    JavadocLegacyConfigRootListener(Config config, Utils utils, ConfigCollector configCollector) {
        super(config, utils, configCollector);
    }

    @Override
    public void onEnclosedField(DiscoveryRootElement discoveryRootElement, TypeElement clazz, VariableElement field, ResolvedType resolvedType) {
        if (this.config.getExtension().isMixedModule() && discoveryRootElement.isConfigMapping()) {
            return;
        }
        if (!this.utils.element().isLocalClass(clazz)) {
            return;
        }
        Optional<String> rawJavadoc = this.utils.element().getJavadoc(field);
        boolean isSection = this.utils.element().isAnnotationPresent(field, "io.quarkus.runtime.annotations.ConfigDocSection");
        if (rawJavadoc.isEmpty()) {
            if (!resolvedType.isConfigGroup() || isSection) {
                this.utils.element().addMissingJavadocError(field);
            }
            return;
        }
        if (isSection) {
            ParsedJavadocSection parsedJavadocSection = JavadocToAsciidocTransformer.INSTANCE.parseConfigSectionJavadoc(rawJavadoc.get());
            this.configCollector.addJavadocElement(clazz.getQualifiedName().toString() + "." + field.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadocSection.title(), null, rawJavadoc.get()));
        } else {
            ParsedJavadoc parsedJavadoc = JavadocToAsciidocTransformer.INSTANCE.parseConfigItemJavadoc(rawJavadoc.get());
            this.configCollector.addJavadocElement(clazz.getQualifiedName().toString() + "." + field.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadoc.description(), parsedJavadoc.since(), rawJavadoc.get()));
        }
    }
}

