/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.merger;

import io.quarkus.annotation.processor.Outputs;
import io.quarkus.annotation.processor.documentation.config.merger.MergedModel;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.annotation.processor.documentation.config.model.ResolvedModel;
import io.quarkus.annotation.processor.documentation.config.util.JacksonMappers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class ModelMerger {
    private ModelMerger() {
    }

    public static MergedModel mergeModel(List<Path> buildOutputDirectories) {
        Map<Extension, Map<String, ConfigRoot>> configRoots = new HashMap<Extension, Map<String, ConfigRoot>>();
        TreeMap<String, ConfigRoot> configRootsInSpecificFile = new TreeMap<String, ConfigRoot>();
        TreeMap<Extension, List<ConfigSection>> generatedConfigSections = new TreeMap<Extension, List<ConfigSection>>();
        for (Path path : buildOutputDirectories) {
            Path resolvedModelPath = path.resolve(Outputs.QUARKUS_CONFIG_DOC_MODEL);
            if (!Files.isReadable(resolvedModelPath)) continue;
            try {
                ResolvedModel resolvedModel = (ResolvedModel)JacksonMappers.yamlObjectReader().readValue(resolvedModelPath.toFile(), ResolvedModel.class);
                if (resolvedModel.getConfigRoots() == null || resolvedModel.getConfigRoots().isEmpty()) continue;
                for (ConfigRoot configRoot : resolvedModel.getConfigRoots()) {
                    if (configRoot.getOverriddenDocFileName() != null) {
                        ConfigRoot existingConfigRootInSpecificFile = (ConfigRoot)configRootsInSpecificFile.get(configRoot.getOverriddenDocFileName());
                        if (existingConfigRootInSpecificFile == null) {
                            configRootsInSpecificFile.put(configRoot.getOverriddenDocFileName(), configRoot);
                            continue;
                        }
                        if (!existingConfigRootInSpecificFile.getExtension().equals(configRoot.getExtension()) || !existingConfigRootInSpecificFile.getPrefix().equals(configRoot.getPrefix())) {
                            throw new IllegalStateException("Two config roots with different extensions or prefixes cannot be merged in the same specific config file: " + configRoot.getOverriddenDocFileName());
                        }
                        existingConfigRootInSpecificFile.merge(configRoot);
                        continue;
                    }
                    Map extensionConfigRoots = configRoots.computeIfAbsent(configRoot.getExtension(), e -> new HashMap());
                    ConfigRoot existingConfigRoot = (ConfigRoot)extensionConfigRoots.get(configRoot.getTopLevelPrefix());
                    if (existingConfigRoot == null) {
                        extensionConfigRoots.put(configRoot.getTopLevelPrefix(), configRoot);
                        continue;
                    }
                    existingConfigRoot.merge(configRoot);
                }
            }
            catch (IOException e2) {
                throw new IllegalStateException("Unable to parse: " + resolvedModelPath, e2);
            }
        }
        configRoots = ModelMerger.retainBestExtensionKey(configRoots);
        for (Map.Entry entry : configRoots.entrySet()) {
            List extensionGeneratedConfigSections = generatedConfigSections.computeIfAbsent((Extension)entry.getKey(), e -> new ArrayList());
            for (ConfigRoot configRoot : ((Map)entry.getValue()).values()) {
                ModelMerger.collectGeneratedConfigSections(extensionGeneratedConfigSections, configRoot);
            }
        }
        return new MergedModel(configRoots, configRootsInSpecificFile, generatedConfigSections);
    }

    private static Map<Extension, Map<String, ConfigRoot>> retainBestExtensionKey(Map<Extension, Map<String, ConfigRoot>> configRoots) {
        return configRoots.entrySet().stream().collect(Collectors.toMap(e -> {
            Extension extension = (Extension)e.getKey();
            for (ConfigRoot configRoot : ((Map)e.getValue()).values()) {
                if (configRoot.getExtension().nameSource().isBetterThan(extension.nameSource())) {
                    extension = configRoot.getExtension();
                }
                if (!Extension.NameSource.EXTENSION_METADATA.equals((Object)extension.nameSource())) continue;
                break;
            }
            return extension;
        }, e -> (Map)e.getValue(), (k1, k2) -> k1, TreeMap::new));
    }

    private static void collectGeneratedConfigSections(List<ConfigSection> extensionGeneratedConfigSections, ConfigItemCollection configItemCollection) {
        for (AbstractConfigItem configItem : configItemCollection.getItems()) {
            if (!configItem.isSection()) continue;
            ConfigSection configSection = (ConfigSection)configItem;
            if (configSection.isGenerated()) {
                extensionGeneratedConfigSections.add(configSection);
            }
            ModelMerger.collectGeneratedConfigSections(extensionGeneratedConfigSections, configSection);
        }
    }
}

