/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.formatter;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.documentation.config.discovery.JavadocFormat;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadoc;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadocSection;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public final class JavadocToAsciidocTransformer {
    public static final JavadocToAsciidocTransformer INSTANCE = new JavadocToAsciidocTransformer();
    public static final JavadocToAsciidocTransformer INLINE_MACRO_INSTANCE = new JavadocToAsciidocTransformer(true);
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);
    private static final Pattern REPLACE_WINDOWS_EOL = Pattern.compile("\r\n");
    private static final Pattern REPLACE_MACOS_EOL = Pattern.compile("\r");
    private static final Pattern STARTING_SPACE = Pattern.compile("^ +");
    private static final String DOT = ".";
    private static final String BACKTICK = "`";
    private static final String HASH = "#";
    private static final String STAR = "*";
    private static final String S_NODE = "s";
    private static final String UNDERSCORE = "_";
    private static final String NEW_LINE = "\n";
    private static final String LINK_NODE = "a";
    private static final String BOLD_NODE = "b";
    private static final String STRONG_NODE = "strong";
    private static final String BIG_NODE = "big";
    private static final String CODE_NODE = "code";
    private static final String DEL_NODE = "del";
    private static final String ITALICS_NODE = "i";
    private static final String EMPHASIS_NODE = "em";
    private static final String TEXT_NODE = "#text";
    private static final String UNDERLINE_NODE = "u";
    private static final String NEW_LINE_NODE = "br";
    private static final String PARAGRAPH_NODE = "p";
    private static final String SMALL_NODE = "small";
    private static final String LIST_ITEM_NODE = "li";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String STRIKE_NODE = "strike";
    private static final String SUB_SCRIPT_NODE = "sub";
    private static final String ORDERED_LIST_NODE = "ol";
    private static final String SUPER_SCRIPT_NODE = "sup";
    private static final String UN_ORDERED_LIST_NODE = "ul";
    private static final String PREFORMATED_NODE = "pre";
    private static final String BLOCKQUOTE_NODE = "blockquote";
    private static final String BIG_ASCIDOC_STYLE = "[.big]";
    private static final String LINK_ATTRIBUTE_FORMAT = "[%s]";
    private static final String SUB_SCRIPT_ASCIDOC_STYLE = "~";
    private static final String SUPER_SCRIPT_ASCIDOC_STYLE = "^";
    private static final String SMALL_ASCIDOC_STYLE = "[.small]";
    private static final String ORDERED_LIST_ITEM_ASCIDOC_STYLE = " . ";
    private static final String UNORDERED_LIST_ITEM_ASCIDOC_STYLE = " - ";
    private static final String UNDERLINE_ASCIDOC_STYLE = "[.underline]";
    private static final String LINE_THROUGH_ASCIDOC_STYLE = "[.line-through]";
    private static final String HARD_LINE_BREAK_ASCIDOC_STYLE = " +\n";
    private static final String CODE_BLOCK_ASCIDOC_STYLE = "```";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE = "[quote]\n____";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END = "____";
    private final boolean inlineMacroMode;

    private JavadocToAsciidocTransformer(boolean inlineMacroMode) {
        this.inlineMacroMode = inlineMacroMode;
    }

    private JavadocToAsciidocTransformer() {
        this(false);
    }

    public ParsedJavadoc parseConfigItemJavadoc(String rawJavadoc) {
        JavadocFormat originalFormat;
        String description;
        if (rawJavadoc == null || rawJavadoc.isBlank()) {
            return ParsedJavadoc.empty();
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)START_OF_LINE.matcher(rawJavadoc).replaceAll("* "));
        if (this.isAsciidoc(javadoc)) {
            description = this.handleEolInAsciidoc(javadoc);
            originalFormat = JavadocFormat.ASCIIDOC;
        } else {
            description = this.htmlJavadocToAsciidoc(javadoc.getDescription());
            originalFormat = JavadocFormat.JAVADOC;
        }
        Optional<String> since = javadoc.getBlockTags().stream().filter(t -> t.getType() == JavadocBlockTag.Type.SINCE).map(JavadocBlockTag::getContent).map(JavadocDescription::toText).findFirst();
        if (description != null && description.isBlank()) {
            description = null;
        }
        return new ParsedJavadoc(description, since.isPresent() ? since.get() : null, originalFormat);
    }

    public ParsedJavadocSection parseConfigSectionJavadoc(String javadocComment) {
        if (javadocComment == null || javadocComment.trim().isEmpty()) {
            return new ParsedJavadocSection(null, null);
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)(javadocComment = START_OF_LINE.matcher(javadocComment).replaceAll("* ")));
        String asciidoc = this.isAsciidoc(javadoc) ? this.handleEolInAsciidoc(javadoc) : this.htmlJavadocToAsciidoc(javadoc.getDescription());
        if (asciidoc == null || asciidoc.isBlank()) {
            return new ParsedJavadocSection(null, null);
        }
        int newLineIndex = asciidoc.indexOf(NEW_LINE);
        int dotIndex = asciidoc.indexOf(DOT);
        int endOfTitleIndex = newLineIndex > 0 && newLineIndex < dotIndex ? newLineIndex : dotIndex;
        if (endOfTitleIndex == -1) {
            String title = asciidoc.replaceAll("^([^\\w])+", "").trim();
            return new ParsedJavadocSection(title, null);
        }
        String title = asciidoc.substring(0, endOfTitleIndex).replaceAll("^([^\\w])+", "").trim();
        String details = asciidoc.substring(endOfTitleIndex + 1).trim();
        return new ParsedJavadocSection(title, details.isBlank() ? null : details);
    }

    private String handleEolInAsciidoc(Javadoc javadoc) {
        String asciidoc = javadoc.getDescription().toText();
        asciidoc = REPLACE_WINDOWS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        asciidoc = REPLACE_MACOS_EOL.matcher(asciidoc).replaceAll(NEW_LINE);
        return asciidoc;
    }

    private boolean isAsciidoc(Javadoc javadoc) {
        for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
            if (!"asciidoclet".equals(blockTag.getTagName())) continue;
            return true;
        }
        return false;
    }

    private String htmlJavadocToAsciidoc(JavadocDescription javadocDescription) {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement javadocDescriptionElement : javadocDescription.getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: {
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    case LINK: 
                    case LINKPLAIN: {
                        if (content.startsWith(HASH)) {
                            content = ConfigNamingUtil.hyphenate(content.substring(1));
                        }
                        sb.append('`');
                        this.appendEscapedAsciiDoc(sb, content);
                        sb.append('`');
                        break;
                    }
                    default: {
                        sb.append(content);
                        break;
                    }
                }
                continue;
            }
            this.appendHtml(sb, (Node)Jsoup.parseBodyFragment((String)javadocDescriptionElement.toText()));
        }
        return JavadocToAsciidocTransformer.trim(sb);
    }

    private void appendHtml(StringBuilder sb, Node node) {
        for (Node childNode : node.childNodes()) {
            switch (childNode.nodeName()) {
                case "p": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "pre": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    for (Node grandChildNode : childNode.childNodes()) {
                        this.unescapeHtmlEntities(sb, grandChildNode.toString());
                    }
                    JavadocToAsciidocTransformer.newLineIfNeeded(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "blockquote": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    this.appendHtml(sb, childNode);
                    JavadocToAsciidocTransformer.newLineIfNeeded(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "ol": 
                case "ul": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "li": {
                    String marker = childNode.parent().nodeName().equals(ORDERED_LIST_NODE) ? ORDERED_LIST_ITEM_ASCIDOC_STYLE : UNORDERED_LIST_ITEM_ASCIDOC_STYLE;
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(marker);
                    this.appendHtml(sb, childNode);
                    break;
                }
                case "a": {
                    String link = childNode.attr(HREF_ATTRIBUTE);
                    sb.append("link:");
                    sb.append(link);
                    StringBuilder caption = new StringBuilder();
                    this.appendHtml(caption, childNode);
                    sb.append(String.format(LINK_ATTRIBUTE_FORMAT, JavadocToAsciidocTransformer.trim(caption)));
                    break;
                }
                case "code": {
                    sb.append(BACKTICK);
                    this.appendHtml(sb, childNode);
                    sb.append(BACKTICK);
                    break;
                }
                case "b": 
                case "strong": {
                    sb.append(STAR);
                    this.appendHtml(sb, childNode);
                    sb.append(STAR);
                    break;
                }
                case "em": 
                case "i": {
                    sb.append(UNDERSCORE);
                    this.appendHtml(sb, childNode);
                    sb.append(UNDERSCORE);
                    break;
                }
                case "u": {
                    sb.append(UNDERLINE_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "small": {
                    sb.append(SMALL_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "big": {
                    sb.append(BIG_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "sub": {
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "sup": {
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    this.appendHtml(sb, childNode);
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "del": 
                case "s": 
                case "strike": {
                    sb.append(LINE_THROUGH_ASCIDOC_STYLE);
                    sb.append(HASH);
                    this.appendHtml(sb, childNode);
                    sb.append(HASH);
                    break;
                }
                case "br": {
                    sb.append(HARD_LINE_BREAK_ASCIDOC_STYLE);
                    break;
                }
                case "#text": {
                    String text = ((TextNode)childNode).text();
                    if (text.isEmpty()) break;
                    Matcher startingSpaceMatcher = STARTING_SPACE.matcher(text);
                    if (sb.length() > 0 && '\n' == sb.charAt(sb.length() - 1) && startingSpaceMatcher.find()) {
                        text = startingSpaceMatcher.replaceFirst("");
                    }
                    this.appendEscapedAsciiDoc(sb, text);
                    break;
                }
                default: {
                    this.appendHtml(sb, childNode);
                }
            }
        }
    }

    static String trim(StringBuilder sb) {
        char ch;
        int length = sb.length();
        int offset = 0;
        while (offset < length) {
            ch = sb.charAt(offset);
            if (ch == ' ' && offset + 2 < length && sb.charAt(offset + 1) == '+' && sb.charAt(offset + 2) == '\n') {
                offset += 3;
                continue;
            }
            if (ch > ' ') break;
            ++offset;
        }
        if (offset > 0) {
            sb.delete(0, offset);
        }
        if (sb.length() > 0) {
            offset = sb.length() - 1;
            while (offset >= 0) {
                ch = sb.charAt(offset);
                if (ch == '\n' && offset - 2 >= 0 && sb.charAt(offset - 1) == '+' && sb.charAt(offset - 2) == ' ') {
                    offset -= 3;
                    continue;
                }
                if (ch > ' ') break;
                --offset;
            }
            if (offset < sb.length() - 1) {
                sb.setLength(offset + 1);
            }
        }
        return sb.toString();
    }

    private static StringBuilder newLineIfNeeded(StringBuilder sb) {
        JavadocToAsciidocTransformer.trimText(sb, " \t\r\n");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder newLine(StringBuilder sb) {
        JavadocToAsciidocTransformer.trimText(sb, " \t");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder trimText(StringBuilder sb, String charsToTrim) {
        while (sb.length() > 0 && charsToTrim.indexOf(sb.charAt(sb.length() - 1)) >= 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private StringBuilder unescapeHtmlEntities(StringBuilder sb, String text) {
        int i = 0;
        block21: while (i < text.length()) {
            switch (text.charAt(i++)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block21;
                }
            }
            --i;
            break;
        }
        while (i < text.length()) {
            char ch = text.charAt(i);
            block4 : switch (ch) {
                case '&': {
                    String abbrev;
                    int start = ++i;
                    while (i < text.length() && text.charAt(i) != ';') {
                        ++i;
                    }
                    if (i <= start) break;
                    switch (abbrev = text.substring(start, i)) {
                        case "lt": {
                            sb.append('<');
                            break block4;
                        }
                        case "gt": {
                            sb.append('>');
                            break block4;
                        }
                        case "nbsp": {
                            sb.append("{nbsp}");
                            break block4;
                        }
                        case "amp": {
                            sb.append('&');
                            break block4;
                        }
                    }
                    try {
                        int code = Integer.parseInt(abbrev);
                        sb.append((char)code);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Could not parse HTML entity &" + abbrev + "; in\n\n" + text + "\n\n");
                    }
                }
                case '\r': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') break;
                    sb.append('\n');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    private StringBuilder appendEscapedAsciiDoc(StringBuilder sb, String text) {
        boolean escaping = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case ']': {
                    if (this.inlineMacroMode) {
                        if (escaping) {
                            sb.append("++");
                            escaping = false;
                        }
                        sb.append("&#93;");
                        continue block5;
                    }
                }
                case '#': 
                case '*': 
                case '[': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    if (!escaping) {
                        sb.append("++");
                        escaping = true;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case '+': {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append("{plus}");
                    continue block5;
                }
                default: {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append(ch);
                }
            }
        }
        if (escaping) {
            sb.append("++");
        }
        return sb;
    }
}

