/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ConfigRoot
implements ConfigItemCollection {
    private final Extension extension;
    private final String prefix;
    private final String topLevelPrefix;
    private final String overriddenDocFileName;
    private final List<AbstractConfigItem> items = new ArrayList<AbstractConfigItem>();
    private final Set<String> qualifiedNames = new HashSet<String>();

    public ConfigRoot(Extension extension, String prefix, String overriddenDocPrefix, String overriddenDocFileName) {
        this.extension = extension;
        this.prefix = prefix;
        this.overriddenDocFileName = overriddenDocFileName;
        this.topLevelPrefix = overriddenDocPrefix != null ? ConfigRoot.buildTopLevelPrefix(overriddenDocPrefix) : ConfigRoot.buildTopLevelPrefix(prefix);
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getOverriddenDocFileName() {
        return this.overriddenDocFileName;
    }

    public void addQualifiedName(String qualifiedName) {
        this.qualifiedNames.add(qualifiedName);
    }

    public Set<String> getQualifiedNames() {
        return Collections.unmodifiableSet(this.qualifiedNames);
    }

    @Override
    public void addItem(AbstractConfigItem item) {
        this.items.add(item);
    }

    @Override
    public List<AbstractConfigItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public String getTopLevelPrefix() {
        return this.topLevelPrefix;
    }

    public void merge(ConfigRoot other) {
        this.qualifiedNames.addAll(other.getQualifiedNames());
        HashMap<String, ConfigSection> existingConfigSections = new HashMap<String, ConfigSection>();
        this.collectConfigSections(existingConfigSections, this);
        for (AbstractConfigItem otherItem : other.getItems()) {
            if (otherItem instanceof ConfigSection) {
                ConfigSection otherConfigSection = (ConfigSection)otherItem;
                ConfigSection similarConfigSection = (ConfigSection)existingConfigSections.get(otherConfigSection.getPath());
                if (similarConfigSection == null) {
                    this.items.add(otherConfigSection);
                    continue;
                }
                similarConfigSection.merge(otherConfigSection, existingConfigSections);
                continue;
            }
            if (otherItem instanceof ConfigProperty) {
                ConfigProperty configProperty = (ConfigProperty)otherItem;
                this.items.add(configProperty);
                continue;
            }
            throw new IllegalStateException("Unknown item type: " + otherItem.getClass());
        }
        Collections.sort(this.items);
    }

    private void collectConfigSections(Map<String, ConfigSection> configSections, ConfigItemCollection configItemCollection) {
        for (AbstractConfigItem item : configItemCollection.getItems()) {
            if (!(item instanceof ConfigSection)) continue;
            ConfigSection configSection = (ConfigSection)item;
            configSections.put(item.getPath(), configSection);
            this.collectConfigSections(configSections, configSection);
        }
    }

    @Override
    public boolean hasDurationType() {
        for (AbstractConfigItem item : this.items) {
            if (!item.hasDurationType() || item.deprecated) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMemorySizeType() {
        for (AbstractConfigItem item : this.items) {
            if (!item.hasMemorySizeType() || item.deprecated) continue;
            return true;
        }
        return false;
    }

    private static String buildTopLevelPrefix(String prefix) {
        String[] prefixSegments = prefix.split(Pattern.quote("."));
        if (prefixSegments.length == 1) {
            return prefixSegments[0];
        }
        return prefixSegments[0] + "." + prefixSegments[1];
    }
}

