/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.discovery;

import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.util.TypeUtil;
import io.quarkus.annotation.processor.util.Strings;

public class DiscoveryConfigProperty {
    private final String path;
    private final String sourceClass;
    private final String sourceName;
    private final String defaultValue;
    private final String defaultValueForDoc;
    private final boolean deprecated;
    private final String mapKey;
    private final boolean unnamedMapKey;
    private final ResolvedType type;
    private final boolean converted;
    private final boolean enforceHyphenateEnumValue;
    private final boolean section;
    private final boolean sectionGenerated;

    public DiscoveryConfigProperty(String path, String sourceClass, String sourceName, String defaultValue, String defaultValueForDoc, boolean deprecated, String mapKey, boolean unnamedMapKey, ResolvedType type, boolean converted, boolean enforceHyphenateEnumValue, boolean section, boolean sectionGenerated) {
        this.path = path;
        this.sourceClass = sourceClass;
        this.sourceName = sourceName;
        this.defaultValue = defaultValue;
        this.defaultValueForDoc = defaultValueForDoc;
        this.deprecated = deprecated;
        this.mapKey = mapKey;
        this.unnamedMapKey = unnamedMapKey;
        this.type = type;
        this.converted = converted;
        this.enforceHyphenateEnumValue = enforceHyphenateEnumValue;
        this.section = section;
        this.sectionGenerated = sectionGenerated;
    }

    public String getPath() {
        return this.path;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueForDoc() {
        return this.defaultValueForDoc;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public boolean isUnnamedMapKey() {
        return this.unnamedMapKey;
    }

    public ResolvedType getType() {
        return this.type;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean isEnforceHyphenateEnumValue() {
        return this.enforceHyphenateEnumValue;
    }

    public boolean isSection() {
        return this.section;
    }

    public boolean isSectionGenerated() {
        return this.sectionGenerated;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + "name = " + this.path + "\n");
        sb.append(prefix + "sourceClass = " + this.sourceClass + "\n");
        sb.append(prefix + "sourceName = " + this.sourceName + "\n");
        sb.append(prefix + "type = " + this.type + "\n");
        if (this.defaultValue != null) {
            sb.append(prefix + "defaultValue = " + this.defaultValue + "\n");
        }
        if (this.defaultValueForDoc != null) {
            sb.append(prefix + "defaultValueForDoc = " + this.defaultValueForDoc + "\n");
        }
        if (this.deprecated) {
            sb.append(prefix + "deprecated = true\n");
        }
        if (this.mapKey != null) {
            sb.append(prefix + "mapKey = " + this.mapKey + "\n");
        }
        if (this.unnamedMapKey) {
            sb.append(prefix + "unnamedMapKey = true\n");
        }
        if (this.converted) {
            sb.append(prefix + "converted = true\n");
        }
        return sb.toString();
    }

    public static Builder builder(String sourceClass, String sourceName, ResolvedType type) {
        return new Builder(sourceClass, sourceName, type);
    }

    public static class Builder {
        private String name;
        private final String sourceClass;
        private final String sourceName;
        private final ResolvedType type;
        private String defaultValue;
        private String defaultValueForDoc;
        private boolean deprecated = false;
        private String mapKey;
        private boolean unnamedMapKey = false;
        private boolean converted = false;
        private boolean enforceHyphenateEnumValue = false;
        private boolean section = false;
        private boolean sectionGenerated = false;

        public Builder(String sourceClass, String sourceName, ResolvedType type) {
            this.sourceClass = sourceClass;
            this.sourceName = sourceName;
            this.type = type;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder defaultValueForDoc(String defaultValueForDoc) {
            this.defaultValueForDoc = defaultValueForDoc;
            return this;
        }

        public Builder deprecated() {
            this.deprecated = true;
            return this;
        }

        public Builder mapKey(String mapKey) {
            this.mapKey = mapKey;
            return this;
        }

        public Builder unnamedMapKey() {
            this.unnamedMapKey = true;
            return this;
        }

        public Builder converted() {
            this.converted = true;
            return this;
        }

        public Builder enforceHyphenateEnumValues() {
            this.enforceHyphenateEnumValue = true;
            return this;
        }

        public Builder section(boolean generated) {
            this.section = true;
            this.sectionGenerated = generated;
            return this;
        }

        public DiscoveryConfigProperty build() {
            if (this.type.isPrimitive() && this.defaultValue == null) {
                this.defaultValue = TypeUtil.getPrimitiveDefaultValue(this.type.qualifiedName());
            }
            if (this.type.isDuration() && !Strings.isBlank(this.defaultValue)) {
                this.defaultValue = TypeUtil.normalizeDurationValue(this.defaultValue);
            }
            return new DiscoveryConfigProperty(this.name, this.sourceClass, this.sourceName, this.defaultValue, this.defaultValueForDoc, this.deprecated, this.mapKey, this.unnamedMapKey, this.type, this.converted, this.enforceHyphenateEnumValue, this.section, this.sectionGenerated);
        }
    }
}

