/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public record Extension(String groupId, String artifactId, String name, NameSource nameSource, boolean detected) implements Comparable<Extension>
{
    public static Extension createNotDetected() {
        return new Extension("not.detected", "not.detected", "Not detected", NameSource.NONE, false);
    }

    @Override
    public final String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.artifactId, this.groupId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extension other = (Extension)obj;
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId);
    }

    @Deprecated(forRemoval=true)
    @JsonIgnore
    public boolean isMixedModule() {
        return "io.quarkus".equals(this.groupId) && ("quarkus-core".equals(this.artifactId) || "quarkus-messaging".equals(this.artifactId));
    }

    @JsonIgnore
    public boolean splitOnConfigRootDescription() {
        return "io.quarkus".equals(this.groupId) && "quarkus-core".equals(this.artifactId);
    }

    @Override
    public int compareTo(Extension other) {
        int nameComparison;
        if (this.name != null && other.name != null && (nameComparison = this.name.compareToIgnoreCase(other.name)) != 0) {
            return nameComparison;
        }
        int groupIdComparison = this.groupId.compareToIgnoreCase(other.groupId);
        if (groupIdComparison != 0) {
            return groupIdComparison;
        }
        return this.artifactId.compareToIgnoreCase(other.artifactId);
    }

    public static enum NameSource {
        EXTENSION_METADATA(100),
        EXTENSION_METADATA_COMMON_INTERNAL(90),
        POM_XML(50),
        POM_XML_COMMON_INTERNAL(40),
        NONE(-1);

        private final int priority;

        private NameSource(int priority) {
            this.priority = priority;
        }

        public boolean isBetterThan(NameSource other) {
            return this.priority > other.priority;
        }
    }
}

