/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemVisitor;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Deprecation;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import io.quarkus.annotation.processor.documentation.config.model.SourceType;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public final class ConfigProperty
extends AbstractConfigItem {
    private final ConfigPhase phase;
    private final List<PropertyPath> additionalPaths;
    private final String typeDescription;
    private final boolean map;
    private final boolean list;
    private final boolean optional;
    private final String mapKey;
    private final boolean unnamedMapKey;
    private final boolean withinMap;
    private final boolean converted;
    private final boolean isEnum;
    private final EnumAcceptedValues enumAcceptedValues;
    private final String defaultValue;
    private final String javadocSiteLink;

    public ConfigProperty(ConfigPhase phase, String sourceClass, String sourceName, SourceType sourceType, PropertyPath path, List<PropertyPath> additionalPaths, String type, String typeDescription, boolean map, boolean list, boolean optional, String mapKey, boolean unnamedMapKey, boolean withinMap, boolean converted, @JsonProperty(value="enum") boolean isEnum, EnumAcceptedValues enumAcceptedValues, String defaultValue, String javadocSiteLink, Deprecation deprecation) {
        super(sourceClass, sourceName, sourceType, path, type, deprecation);
        this.phase = phase;
        this.additionalPaths = additionalPaths != null ? Collections.unmodifiableList(additionalPaths) : List.of();
        this.typeDescription = typeDescription;
        this.map = map;
        this.list = list;
        this.optional = optional;
        this.mapKey = mapKey;
        this.unnamedMapKey = unnamedMapKey;
        this.withinMap = withinMap;
        this.converted = converted;
        this.isEnum = isEnum;
        this.enumAcceptedValues = enumAcceptedValues;
        this.defaultValue = defaultValue;
        this.javadocSiteLink = javadocSiteLink;
    }

    public ConfigPhase getPhase() {
        return this.phase;
    }

    @Override
    public PropertyPath getPath() {
        return (PropertyPath)super.getPath();
    }

    public List<PropertyPath> getAdditionalPaths() {
        return this.additionalPaths;
    }

    @Deprecated
    @JsonIgnore
    public String getEnvironmentVariable() {
        return this.getPath().environmentVariable();
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public boolean isMap() {
        return this.map;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public boolean isUnnamedMapKey() {
        return this.unnamedMapKey;
    }

    public boolean isWithinMap() {
        return this.withinMap;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public EnumAcceptedValues getEnumAcceptedValues() {
        return this.enumAcceptedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getJavadocSiteLink() {
        return this.javadocSiteLink;
    }

    @Override
    public boolean isSection() {
        return false;
    }

    @Override
    public int compareTo(AbstractConfigItem o) {
        if (o instanceof ConfigSection) {
            return -1;
        }
        ConfigProperty other = (ConfigProperty)o;
        if (this.isWithinMap()) {
            if (other.isWithinMap()) {
                return ConfigPhase.COMPARATOR.compare(this.phase, other.getPhase());
            }
            return 1;
        }
        if (other.isWithinMap()) {
            return -1;
        }
        return ConfigPhase.COMPARATOR.compare(this.phase, other.getPhase());
    }

    @Override
    public boolean hasDurationType() {
        return Duration.class.getName().equals(this.type);
    }

    @Override
    public boolean hasMemorySizeType() {
        return "io.quarkus.runtime.configuration.MemorySize".equals(this.type);
    }

    @Override
    protected void walk(ConfigItemVisitor visitor) {
        visitor.visit(this);
    }

    public record PropertyPath(String property, String environmentVariable) implements AbstractConfigItem.Path
    {
        @Override
        public String toString() {
            return this.property();
        }
    }
}

