/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.util;

import io.quarkus.annotation.processor.util.ElementUtil;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;

public final class AccessorGenerator {
    private static final String QUARKUS_GENERATED = "io.quarkus.Generated";
    private static final String INSTANCE_SYM = "__instance";
    private final ProcessingEnvironment processingEnv;
    private final ElementUtil elementUtil;
    private final Set<String> generatedAccessors = new ConcurrentHashMap().keySet(Boolean.TRUE);

    AccessorGenerator(ProcessingEnvironment processingEnv, ElementUtil elementUtil) {
        this.processingEnv = processingEnv;
        this.elementUtil = elementUtil;
    }

    public void generateAccessor(TypeElement clazz) {
        DeclaredType declaredType;
        TypeMirror enclosingType;
        if (!this.generatedAccessors.add(clazz.getQualifiedName().toString())) {
            return;
        }
        FormatPreferences fp = new FormatPreferences();
        JSources sources = JDeparser.createSources((JFiler)JFiler.newInstance((Filer)this.processingEnv.getFiler()), (FormatPreferences)fp);
        PackageElement packageElement = this.elementUtil.getPackageOf(clazz);
        String className = this.elementUtil.buildRelativeBinaryName(clazz, new StringBuilder()).append("$$accessor").toString();
        JSourceFile sourceFile = sources.createSourceFile(packageElement.getQualifiedName().toString(), className);
        JType clazzType = JTypes.typeOf((TypeMirror)clazz.asType());
        if (clazz.asType() instanceof DeclaredType && (enclosingType = (declaredType = (DeclaredType)clazz.asType()).getEnclosingType()) != null && enclosingType.getKind() == TypeKind.DECLARED && clazz.getModifiers().contains((Object)Modifier.STATIC)) {
            clazzType = this.unnestStaticNestedType(declaredType);
        }
        JClassDef classDef = sourceFile._class(34, className);
        classDef.constructor(8);
        classDef.annotate(QUARKUS_GENERATED).value("Quarkus annotation processor");
        JAssignableExpr instanceName = JExprs.name((String)INSTANCE_SYM);
        boolean isEnclosingClassPublic = clazz.getModifiers().contains((Object)Modifier.PUBLIC);
        boolean generationNeeded = false;
        for (VariableElement field : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
            DeclaredType declaredType2;
            TypeElement typeElement;
            Set<Modifier> mods = field.getModifiers();
            if (mods.contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.STATIC) || mods.contains((Object)Modifier.FINAL)) continue;
            TypeMirror fieldType = field.asType();
            if (mods.contains((Object)Modifier.PUBLIC) && isEnclosingClassPublic && (!(fieldType instanceof DeclaredType) || (typeElement = (TypeElement)(declaredType2 = (DeclaredType)fieldType).asElement()).getModifiers().contains((Object)Modifier.PUBLIC))) continue;
            generationNeeded = true;
            JType jType = JTypes.typeOf((TypeMirror)fieldType);
            JType publicType = fieldType instanceof PrimitiveType ? jType : JType.OBJECT;
            String fieldName = field.getSimpleName().toString();
            JMethodDef jMethodDef = classDef.method(96, publicType, "get_" + fieldName);
            jMethodDef.annotate(SuppressWarnings.class).value("unchecked");
            jMethodDef.param(JType.OBJECT, INSTANCE_SYM);
            jMethodDef.body()._return((JExpr)instanceName.cast(clazzType).field(fieldName));
            JMethodDef setter = classDef.method(96, JType.VOID, "set_" + fieldName);
            setter.annotate(SuppressWarnings.class).value("unchecked");
            setter.param(JType.OBJECT, INSTANCE_SYM);
            setter.param(publicType, fieldName);
            JAssignableExpr fieldExpr = JExprs.name((String)fieldName);
            setter.body().assign(instanceName.cast(clazzType).field(fieldName), (JExpr)(publicType.equals(jType) ? fieldExpr : fieldExpr.cast(jType)));
        }
        if (!isEnclosingClassPublic) {
            for (ExecutableElement ctor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
                if (ctor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                generationNeeded = true;
                StringBuilder b = new StringBuilder();
                for (VariableElement variableElement : ctor.getParameters()) {
                    b.append('_');
                    b.append(variableElement.asType().toString().replace('.', '_'));
                }
                String codedName = b.toString();
                JMethodDef jMethodDef = classDef.method(96, JType.OBJECT, "construct" + codedName);
                JCall ctorCall = clazzType._new();
                for (VariableElement variableElement : ctor.getParameters()) {
                    TypeMirror paramType = variableElement.asType();
                    JType realType = JTypes.typeOf((TypeMirror)paramType);
                    JType publicType = paramType instanceof PrimitiveType ? realType : JType.OBJECT;
                    String name = variableElement.getSimpleName().toString();
                    jMethodDef.param(publicType, name);
                    JAssignableExpr nameExpr = JExprs.name((String)name);
                    ctorCall.arg((JExpr)(publicType.equals(realType) ? nameExpr : nameExpr.cast(realType)));
                }
                jMethodDef.body()._return((JExpr)ctorCall);
            }
        }
        if (generationNeeded) {
            try {
                sources.writeSources();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate source file: " + e, clazz);
            }
        }
    }

    private JType unnestStaticNestedType(DeclaredType declaredType) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String name = typeElement.getQualifiedName().toString();
        JType rawType = JTypes.typeNamed((String)name);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return rawType;
        }
        JType[] args = new JType[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            TypeMirror argument = typeArguments.get(i);
            args[i] = JTypes.typeOf((TypeMirror)argument);
        }
        return rawType.typeArg(args);
    }
}

