/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.util;

import io.quarkus.annotation.processor.documentation.config.model.Extension;
import io.quarkus.annotation.processor.documentation.config.model.ExtensionModule;
import io.quarkus.annotation.processor.util.FilerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExtensionUtil {
    private static final String RUNTIME_MARKER_FILE = "META-INF/quarkus-extension.properties";
    private static final String ARTIFACT_DEPLOYMENT_SUFFIX = "-deployment";
    private static final String NAME_QUARKUS_PREFIX = "Quarkus - ";
    private static final String NAME_RUNTIME_SUFFIX = " - Runtime";
    private static final String NAME_DEPLOYMENT_SUFFIX = " - Deployment";
    private final ProcessingEnvironment processingEnv;
    private final FilerUtil filerUtil;

    ExtensionUtil(ProcessingEnvironment processingEnv, FilerUtil filerUtil) {
        this.processingEnv = processingEnv;
        this.filerUtil = filerUtil;
    }

    public ExtensionModule getExtensionModule() {
        Document doc;
        Optional<Path> pom = this.filerUtil.getPomPath();
        if (pom.isEmpty()) {
            return ExtensionModule.createNotDetected();
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(pom.get().toFile());
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse pom file: " + pom, e);
        }
        return this.getExtensionModuleFromPom(pom.get(), doc);
    }

    private ExtensionModule getExtensionModuleFromPom(Path pom, Document doc) {
        Extension.NameSource extensionNameSource;
        String parentGroupId = null;
        String artifactId = null;
        String groupId = null;
        String name = null;
        String guideUrl = null;
        NodeList children = doc.getDocumentElement().getChildNodes();
        block0: for (int i = 0; i < children.getLength() && (groupId == null || artifactId == null || name == null); ++i) {
            Node child = children.item(i);
            if ("parent".equals(child.getNodeName())) {
                NodeList parentChildren = child.getChildNodes();
                for (int j = 0; j < parentChildren.getLength(); ++j) {
                    Node parentChild = parentChildren.item(j);
                    if (!"groupId".equals(parentChild.getNodeName())) continue;
                    parentGroupId = parentChild.getTextContent() != null ? parentChild.getTextContent().trim() : null;
                    continue block0;
                }
                continue;
            }
            if ("groupId".equals(child.getNodeName())) {
                groupId = child.getTextContent() != null ? child.getTextContent().trim() : null;
                continue;
            }
            if ("artifactId".equals(child.getNodeName())) {
                artifactId = child.getTextContent() != null ? child.getTextContent().trim() : null;
                continue;
            }
            if (!"name".equals(child.getNodeName())) continue;
            name = child.getTextContent() != null ? child.getTextContent().trim() : null;
        }
        if (groupId == null) {
            groupId = parentGroupId;
        }
        if (groupId == null || groupId.isBlank() || artifactId == null || artifactId.isBlank()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine artifact coordinates from: " + pom);
            return ExtensionModule.createNotDetected();
        }
        ExtensionModule.ExtensionModuleType moduleType = this.detectExtensionModuleType(artifactId);
        String extensionArtifactId = moduleType == ExtensionModule.ExtensionModuleType.DEPLOYMENT ? artifactId.substring(0, artifactId.length() - ARTIFACT_DEPLOYMENT_SUFFIX.length()) : artifactId;
        Optional<ExtensionMetadata> extensionMetadata = this.getExtensionMetadata();
        if (extensionMetadata.isPresent()) {
            name = extensionMetadata.get().name();
            extensionNameSource = Extension.NameSource.EXTENSION_METADATA;
            guideUrl = extensionMetadata.get().guideUrl();
        } else {
            extensionNameSource = name != null ? Extension.NameSource.POM_XML : Extension.NameSource.NONE;
        }
        String extensionName = name;
        if (extensionName != null) {
            if (extensionName.startsWith(NAME_QUARKUS_PREFIX)) {
                extensionName = extensionName.substring(NAME_QUARKUS_PREFIX.length()).trim();
            }
            if (moduleType == ExtensionModule.ExtensionModuleType.DEPLOYMENT && extensionName.endsWith(NAME_DEPLOYMENT_SUFFIX)) {
                extensionName = extensionName.substring(0, extensionName.length() - NAME_DEPLOYMENT_SUFFIX.length());
            }
            if (moduleType == ExtensionModule.ExtensionModuleType.RUNTIME && extensionName.endsWith(NAME_RUNTIME_SUFFIX)) {
                extensionName = extensionName.substring(0, extensionName.length() - NAME_RUNTIME_SUFFIX.length());
            }
        }
        return ExtensionModule.of(groupId, artifactId, moduleType, Extension.of(groupId, extensionArtifactId, extensionName, extensionNameSource, guideUrl, Boolean.parseBoolean(this.processingEnv.getOptions().getOrDefault("splitOnConfigRootDescription", "false"))));
    }

    private Optional<ExtensionMetadata> getExtensionMetadata() {
        Optional<Map<String, Object>> extensionMetadata = this.filerUtil.getExtensionMetadata();
        if (extensionMetadata.isEmpty()) {
            return Optional.empty();
        }
        String extensionName = (String)extensionMetadata.get().get("name");
        if (extensionName == null || extensionName.isBlank()) {
            return Optional.empty();
        }
        extensionName = extensionName.trim();
        Map metadata = (Map)extensionMetadata.get().get("metadata");
        String guideUrl = null;
        if (metadata != null) {
            guideUrl = (String)metadata.get("guide");
            guideUrl = guideUrl == null || guideUrl.isBlank() ? null : guideUrl.trim();
        }
        return Optional.of(new ExtensionMetadata(extensionName, guideUrl));
    }

    private ExtensionModule.ExtensionModuleType detectExtensionModuleType(String artifactId) {
        try {
            Path runtimeMarkerFile = Paths.get(this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", RUNTIME_MARKER_FILE).toUri());
            if (Files.exists(runtimeMarkerFile, new LinkOption[0])) {
                return ExtensionModule.ExtensionModuleType.RUNTIME;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (artifactId.endsWith(ARTIFACT_DEPLOYMENT_SUFFIX)) {
            return ExtensionModule.ExtensionModuleType.DEPLOYMENT;
        }
        return ExtensionModule.ExtensionModuleType.UNKNOWN;
    }

    private record ExtensionMetadata(String name, String guideUrl) {
    }
}

