/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDoc;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ConfigDocBuilder {
    private static final String DECLARE_VAR = "\n:%s: %s\n";
    private final DocFormatter summaryTableDocFormatter;
    protected final List<ConfigDoc.WriteItem> writeItems = new ArrayList<ConfigDoc.WriteItem>();

    public ConfigDocBuilder() {
        this.summaryTableDocFormatter = new SummaryTableDocFormatter();
    }

    protected ConfigDocBuilder(boolean showEnvVars) {
        this.summaryTableDocFormatter = new SummaryTableDocFormatter(showEnvVars);
    }

    protected ConfigDocBuilder(boolean showEnvVars, boolean replaceDotsInAnchors) {
        this.summaryTableDocFormatter = new SummaryTableDocFormatter(showEnvVars, replaceDotsInAnchors);
    }

    public final ConfigDocBuilder addSummaryTable(String initialAnchorPrefix, boolean activateSearch, List<ConfigDocItem> configDocItems, String fileName, boolean includeConfigPhaseLegend) {
        this.writeItems.add(writer -> {
            String fileNameWithoutExtension = fileName.substring(0, fileName.length() - ".adoc".length());
            writer.append(String.format(DECLARE_VAR, "summaryTableId", fileNameWithoutExtension));
            this.summaryTableDocFormatter.format(writer, initialAnchorPrefix, activateSearch, configDocItems, includeConfigPhaseLegend);
            boolean hasDuration = false;
            boolean hasMemory = false;
            for (ConfigDocItem item : configDocItems) {
                if (item.hasDurationInformationNote()) {
                    hasDuration = true;
                }
                if (!item.hasMemoryInformationNote()) continue;
                hasMemory = true;
            }
            if (hasDuration) {
                writer.append(Constants.DURATION_FORMAT_NOTE);
            }
            if (hasMemory) {
                writer.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
        });
        return this;
    }

    public boolean hasWriteItems() {
        return !this.writeItems.isEmpty();
    }

    public final ConfigDocBuilder write(String ... strings) {
        Objects.requireNonNull(strings);
        this.writeItems.add(writer -> {
            for (String str : strings) {
                writer.append(str);
            }
        });
        return this;
    }

    public final ConfigDoc build() {
        List<ConfigDoc.WriteItem> docItemsCopy = List.copyOf(this.writeItems);
        return () -> docItemsCopy;
    }
}

