/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemVisitor;
import io.quarkus.annotation.processor.documentation.config.model.Deprecation;
import io.quarkus.annotation.processor.documentation.config.model.SourceElementType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class AbstractConfigItem
implements Comparable<AbstractConfigItem> {
    protected final String sourceType;
    protected final String sourceElementName;
    protected final SourceElementType sourceElementType;
    protected final Path path;
    protected final String type;
    protected Deprecation deprecation;

    public AbstractConfigItem(String sourceType, String sourceElementName, SourceElementType sourceElementType, Path path, String type, Deprecation deprecation) {
        this.sourceType = sourceType;
        this.sourceElementName = sourceElementName;
        this.sourceElementType = sourceElementType;
        this.path = path;
        this.type = type;
        this.deprecation = deprecation;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceElementName() {
        return this.sourceElementName;
    }

    public SourceElementType getSourceElementType() {
        return this.sourceElementType;
    }

    public Path getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isDeprecated() {
        return this.deprecation != null;
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    @JsonIgnore
    public abstract boolean isSection();

    @JsonIgnore
    public abstract boolean hasDurationType();

    @JsonIgnore
    public abstract boolean hasMemorySizeType();

    protected abstract void walk(ConfigItemVisitor var1);

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    public static interface Path {
        public String property();
    }
}

