/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.util;

import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigNamingUtil {
    private static final String CONFIG = "Config";
    private static final String CONFIGURATION = "Configuration";
    private static final String HYPHEN = "-";
    private static final Pattern ENUM_SEPARATOR_PATTERN = Pattern.compile("([-_]+)");
    private static final String NAMED_MAP_CONFIG_ITEM_FORMAT = ".\"%s\"";

    private ConfigNamingUtil() {
    }

    public static String getRootPrefix(String prefix, String name, String simpleClassName, ConfigPhase configPhase) {
        Object rootPrefix = name.equals("<<hyphenated element name>>") ? ConfigNamingUtil.deriveConfigRootName(simpleClassName, prefix, configPhase) : (!prefix.isEmpty() ? (!name.isEmpty() ? prefix + "." + name : prefix) : name);
        if (((String)rootPrefix).endsWith(".<<parent>>")) {
            rootPrefix = ((String)rootPrefix).replace(".<<parent>>", "");
        }
        return rootPrefix;
    }

    static String deriveConfigRootName(String simpleClassName, String prefix, ConfigPhase configPhase) {
        String simpleNameInLowerCase = simpleClassName.toLowerCase();
        int length = simpleNameInLowerCase.length();
        if (simpleNameInLowerCase.endsWith(CONFIG.toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - CONFIG.length());
            return ConfigNamingUtil.deriveConfigRootName(sanitized, prefix, configPhase);
        }
        if (simpleNameInLowerCase.endsWith(CONFIGURATION.toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - CONFIGURATION.length());
            return ConfigNamingUtil.deriveConfigRootName(sanitized, prefix, configPhase);
        }
        if (simpleNameInLowerCase.endsWith(configPhase.getConfigSuffix().toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - configPhase.getConfigSuffix().length());
            return ConfigNamingUtil.deriveConfigRootName(sanitized, prefix, configPhase);
        }
        return !prefix.isEmpty() ? prefix + "." + ConfigNamingUtil.hyphenate(simpleClassName) : "quarkus." + ConfigNamingUtil.hyphenate(simpleClassName);
    }

    public static Iterator<String> camelHumpsIterator(final String str) {
        return new Iterator<String>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < str.length();
            }

            @Override
            public String next() {
                if (this.idx == str.length()) {
                    throw new NoSuchElementException();
                }
                if (str.startsWith("JBoss", this.idx)) {
                    this.idx += 5;
                    return "JBoss";
                }
                int start = this.idx;
                int c = str.codePointAt(this.idx);
                if (Character.isUpperCase(c)) {
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                    if (this.idx < str.length()) {
                        c = str.codePointAt(this.idx);
                        if (Character.isUpperCase(c)) {
                            int nextIdx = str.offsetByCodePoints(this.idx, 1);
                            while (nextIdx < str.length()) {
                                c = str.codePointAt(nextIdx);
                                if (Character.isLowerCase(c)) {
                                    return str.substring(start, this.idx);
                                }
                                this.idx = nextIdx;
                                nextIdx = str.offsetByCodePoints(this.idx, 1);
                            }
                            this.idx = str.length();
                            return str.substring(start);
                        }
                        this.idx = str.offsetByCodePoints(this.idx, 1);
                        while (this.idx < str.length()) {
                            c = str.codePointAt(this.idx);
                            if (Character.isUpperCase(c)) {
                                return str.substring(start, this.idx);
                            }
                            this.idx = str.offsetByCodePoints(this.idx, 1);
                        }
                        return str.substring(start);
                    }
                    return str.substring(start);
                }
                this.idx = str.offsetByCodePoints(this.idx, 1);
                while (this.idx < str.length()) {
                    c = str.codePointAt(this.idx);
                    if (Character.isUpperCase(c)) {
                        return str.substring(start, this.idx);
                    }
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                }
                return str.substring(start);
            }
        };
    }

    static Iterator<String> lowerCase(final Iterator<String> orig) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return orig.hasNext();
            }

            @Override
            public String next() {
                return ((String)orig.next()).toLowerCase(Locale.ROOT);
            }
        };
    }

    static String join(Iterator<String> it) {
        StringBuilder b = new StringBuilder();
        if (it.hasNext()) {
            b.append(it.next());
            while (it.hasNext()) {
                b.append(HYPHEN);
                b.append(it.next());
            }
        }
        return b.toString();
    }

    public static String hyphenate(String orig) {
        return ConfigNamingUtil.join(ConfigNamingUtil.lowerCase(ConfigNamingUtil.camelHumpsIterator(orig)));
    }

    public static String hyphenateEnumValue(String orig) {
        StringBuffer target = new StringBuffer();
        String hyphenate = ConfigNamingUtil.hyphenate(orig);
        Matcher matcher = ENUM_SEPARATOR_PATTERN.matcher(hyphenate);
        while (matcher.find()) {
            matcher.appendReplacement(target, HYPHEN);
        }
        matcher.appendTail(target);
        return target.toString();
    }

    static String normalizeDurationValue(String value) {
        if (!((String)value).isEmpty() && Character.isDigit(((String)value).charAt(((String)value).length() - 1))) {
            try {
                value = Integer.parseInt((String)value) + "S";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        value = ((String)value).toUpperCase(Locale.ROOT);
        return value;
    }

    public static String toEnvVarName(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString().toUpperCase();
    }

    public static String getMapKey(String mapKey) {
        return String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, mapKey);
    }
}

