/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDoc;
import io.quarkus.annotation.processor.generate_doc.ConfigDocBuilder;
import io.quarkus.annotation.processor.generate_doc.ConfigDocGeneratedOutput;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class ConfigDocWriter {
    public void writeAllExtensionConfigDocumentation(ConfigDocGeneratedOutput output) throws IOException {
        if (output.getConfigDocItems().isEmpty()) {
            return;
        }
        ConfigDocBuilder configDocBuilder = new ConfigDocBuilder().addSummaryTable(output.getAnchorPrefix(), output.isSearchable(), output.getConfigDocItems(), output.getFileName(), true);
        this.generateDocumentation(output.getFileName(), configDocBuilder);
    }

    public void generateDocumentation(String fileName, ConfigDocBuilder configDocBuilder) throws IOException {
        this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve(fileName), configDocBuilder.build());
    }

    private void generateDocumentation(Path targetPath, ConfigDoc configDoc) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, new OpenOption[0]);){
            for (ConfigDoc.WriteItem writeItem : configDoc.getWriteItems()) {
                writeItem.accept(writer);
            }
        }
    }
}

