/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocGeneratedOutput;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItemFinder;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.FsMap;
import io.quarkus.annotation.processor.generate_doc.FsMultiMap;
import io.quarkus.annotation.processor.generate_doc.ScannedConfigDocsItemHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public final class ConfigDocItemScanner {
    private static final String IO_QUARKUS_TEST_EXTENSION_PACKAGE = "io.quarkus.extest.";
    private final Set<ConfigRootInfo> configRoots = new HashSet<ConfigRootInfo>();
    private final Map<String, TypeElement> configGroupsToTypeElement = new HashMap<String, TypeElement>();
    private final FsMap allExtensionGeneratedDocs = new FsMap(Constants.GENERATED_DOCS_PATH.resolve("all-configuration-roots-generated-doc"));
    private final FsMap allConfigGroupGeneratedDocs = new FsMap(Constants.GENERATED_DOCS_PATH.resolve("all-configuration-groups-generated-doc"));
    private final FsMultiMap configurationRootsParExtensionFileName = new FsMultiMap(Constants.GENERATED_DOCS_PATH.resolve("extensions-configuration-roots-list"));

    public void addConfigGroups(TypeElement configGroup) {
        String configGroupName = configGroup.getQualifiedName().toString();
        if (configGroupName.startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        this.configGroupsToTypeElement.put(configGroupName, configGroup);
    }

    public void addConfigRoot(PackageElement pkg, TypeElement clazz) {
        if (pkg.toString().startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        String prefix = "quarkus";
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            String annotationName = annotationMirror.getAnnotationType().toString();
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            String name = "<<hyphenated element name>>";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String string = entry.getKey().toString();
                String string2 = entry.getValue().getValue().toString();
                if ("name()".equals(string)) {
                    name = string2;
                    continue;
                }
                if ("phase()".equals(string)) {
                    configPhase = ConfigPhase.valueOf(string2);
                    continue;
                }
                if (!"prefix()".equals(string)) continue;
                prefix = string2;
            }
            for (AnnotationMirror annotationMirror2 : clazz.getAnnotationMirrors()) {
                if (!annotationMirror2.getAnnotationType().toString().equals("io.smallrye.config.ConfigMapping")) continue;
                name = "";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror2.getElementValues().entrySet()) {
                    if (!"prefix()".equals(entry.getKey().toString())) continue;
                    prefix = entry.getValue().getValue().toString();
                }
            }
            Object docFileName = null;
            block4: for (AnnotationMirror annotationMirror3 : clazz.getAnnotationMirrors()) {
                if (!annotationMirror3.getAnnotationType().toString().equals("io.quarkus.runtime.annotations.ConfigDocFilename")) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror3.getElementValues().entrySet()) {
                    if (!"value()".equals(entry.getKey().toString())) continue;
                    docFileName = entry.getValue().getValue().toString();
                    break block4;
                }
            }
            if ((name = DocGeneratorUtil.getName(prefix, name, clazz.getSimpleName().toString(), configPhase)).endsWith(".<<parent>>")) {
                name = name.replace(".<<parent>>", "");
            }
            if (docFileName == null || ((String)docFileName).isEmpty()) {
                Matcher matcher = Constants.PKG_PATTERN.matcher(pkg.toString());
                docFileName = matcher.find() ? DocGeneratorUtil.computeExtensionDocFileName(clazz.toString()) : name.replace('.', "-".charAt(0)) + ".adoc";
            }
            ConfigRootInfo configRootInfo = new ConfigRootInfo(name, clazz, configPhase, (String)docFileName);
            this.configRoots.add(configRootInfo);
            break;
        }
    }

    public Set<ConfigDocGeneratedOutput> scanExtensionsConfigurationItems(Properties javaDocProperties, boolean configMapping) throws IOException {
        HashSet<ConfigDocGeneratedOutput> configDocGeneratedOutputs = new HashSet<ConfigDocGeneratedOutput>();
        ConfigDocItemFinder configDocItemFinder = new ConfigDocItemFinder(this.configRoots, this.configGroupsToTypeElement, javaDocProperties, this.allConfigGroupGeneratedDocs, this.allExtensionGeneratedDocs, configMapping);
        ScannedConfigDocsItemHolder inMemoryScannedItemsHolder = configDocItemFinder.findInMemoryConfigurationItems();
        if (!inMemoryScannedItemsHolder.isEmpty()) {
            this.updateScannedExtensionArtifactFiles(inMemoryScannedItemsHolder);
        }
        Set<ConfigDocGeneratedOutput> allConfigItemsPerExtension = this.generateAllConfigItemsOutputs(inMemoryScannedItemsHolder);
        Set<ConfigDocGeneratedOutput> configGroupConfigItems = this.generateAllConfigGroupOutputs(inMemoryScannedItemsHolder);
        Set<ConfigDocGeneratedOutput> configRootConfigItems = this.generateAllConfigRootOutputs(inMemoryScannedItemsHolder);
        configDocGeneratedOutputs.addAll(configGroupConfigItems);
        configDocGeneratedOutputs.addAll(allConfigItemsPerExtension);
        configDocGeneratedOutputs.addAll(configRootConfigItems);
        return configDocGeneratedOutputs;
    }

    private Properties loadAllExtensionConfigItemsParConfigRoot() {
        return this.allExtensionGeneratedDocs.asProperties();
    }

    private void updateConfigurationRootsList(Map.Entry<ConfigRootInfo, List<ConfigDocItem>> entry) {
        String extensionFileName = entry.getKey().getFileName();
        String clazz = entry.getKey().getClazz().getQualifiedName().toString();
        this.configurationRootsParExtensionFileName.put(extensionFileName, clazz);
    }

    private void updateScannedExtensionArtifactFiles(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder) throws IOException {
        for (Map.Entry<ConfigRootInfo, List<ConfigDocItem>> entry : inMemoryScannedItemsHolder.getConfigRootConfigItems().entrySet()) {
            String serializableConfigRootDoc = Constants.OBJECT_MAPPER.writeValueAsString(entry.getValue());
            String clazz = entry.getKey().getClazz().getQualifiedName().toString();
            this.allExtensionGeneratedDocs.put(clazz, serializableConfigRootDoc);
            this.updateConfigurationRootsList(entry);
        }
    }

    private Set<ConfigDocGeneratedOutput> generateAllConfigItemsOutputs(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder) throws IOException {
        HashSet<ConfigDocGeneratedOutput> outputs = new HashSet<ConfigDocGeneratedOutput>();
        Set extensionFileNamesToGenerate = inMemoryScannedItemsHolder.getConfigRootConfigItems().keySet().stream().map(ConfigRootInfo::getFileName).collect(Collectors.toSet());
        for (String extensionFileName : extensionFileNamesToGenerate) {
            ArrayList<ConfigDocItem> extensionConfigItems = new ArrayList<ConfigDocItem>();
            for (String configRoot : this.configurationRootsParExtensionFileName.get(extensionFileName)) {
                List configDocItems = inMemoryScannedItemsHolder.getConfigItemsByRootClassName(configRoot);
                if (configDocItems == null) {
                    String serializedContent = this.allExtensionGeneratedDocs.get(configRoot);
                    configDocItems = (List)Constants.OBJECT_MAPPER.readValue(serializedContent, Constants.LIST_OF_CONFIG_ITEMS_TYPE_REF);
                }
                DocGeneratorUtil.appendConfigItemsIntoExistingOnes(extensionConfigItems, configDocItems);
            }
            outputs.add(new ConfigDocGeneratedOutput(extensionFileName, true, extensionConfigItems, true));
            List<ConfigDocItem> generalConfigItems = extensionConfigItems.stream().filter(ConfigDocItem::isWithinAConfigGroup).collect(Collectors.toList());
            if (generalConfigItems.isEmpty()) continue;
            String fileName = extensionFileName.replaceAll("\\.adoc$", "-general-config-items.adoc");
            outputs.add(new ConfigDocGeneratedOutput(fileName, false, generalConfigItems, true));
        }
        return outputs;
    }

    private Set<ConfigDocGeneratedOutput> generateAllConfigGroupOutputs(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder) {
        return inMemoryScannedItemsHolder.getConfigGroupConfigItems().entrySet().stream().map(entry -> new ConfigDocGeneratedOutput(DocGeneratorUtil.computeConfigGroupDocFileName((String)entry.getKey()), false, (List)entry.getValue(), true)).collect(Collectors.toSet());
    }

    private Set<ConfigDocGeneratedOutput> generateAllConfigRootOutputs(ScannedConfigDocsItemHolder inMemoryScannedItemsHolder) {
        HashSet<ConfigDocGeneratedOutput> outputs = new HashSet<ConfigDocGeneratedOutput>();
        for (ConfigRootInfo configRootInfo : this.configRoots) {
            String clazz = configRootInfo.getClazz().getQualifiedName().toString();
            List<ConfigDocItem> configDocItems = inMemoryScannedItemsHolder.getConfigItemsByRootClassName(clazz);
            String fileName = DocGeneratorUtil.computeConfigRootDocFileName(clazz, configRootInfo.getName());
            outputs.add(new ConfigDocGeneratedOutput(fileName, false, configDocItems, true));
        }
        return outputs;
    }

    public Map<String, List<ConfigDocItem>> loadAllExtensionsConfigurationItems() throws IOException {
        Properties allExtensionGeneratedDocs = this.loadAllExtensionConfigItemsParConfigRoot();
        HashMap<String, List<ConfigDocItem>> foundExtensionConfigurationItems = new HashMap<String, List<ConfigDocItem>>();
        for (Map.Entry<Object, Object> entry : allExtensionGeneratedDocs.entrySet()) {
            String serializedContent = (String)entry.getValue();
            if (serializedContent == null) continue;
            List configDocItems = (List)Constants.OBJECT_MAPPER.readValue(serializedContent, Constants.LIST_OF_CONFIG_ITEMS_TYPE_REF);
            foundExtensionConfigurationItems.put((String)entry.getKey(), configDocItems);
        }
        return foundExtensionConfigurationItems;
    }

    public String toString() {
        return "ConfigDocItemScanner{configRoots=" + this.configRoots + ", configGroups=" + this.configGroupsToTypeElement + "}";
    }
}

