/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayProducer;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

class FlywayDatasourceBeanGenerator {
    public static final String FLYWAY_BEAN_NAME_PREFIX = "flyway_";
    private static final String FLYWAY_PRODUCER_BEAN_NAME = "FlywayDataSourceProducer";
    private static final String FLYWAY_PRODUCER_PACKAGE_NAME = FlywayProducer.class.getPackage().getName();
    private static final String FLYWAY_PRODUCER_TYPE_NAME = FLYWAY_PRODUCER_PACKAGE_NAME + "." + "FlywayDataSourceProducer";
    private static final int ACCESS_PACKAGE_PROTECTED = 0;
    private final Collection<String> namedDataSourceNames;
    private final BuildProducer<GeneratedBeanBuildItem> generatedBean;

    public FlywayDatasourceBeanGenerator(Collection<String> dataSourceNames, BuildProducer<GeneratedBeanBuildItem> generatedBean) {
        this.namedDataSourceNames = dataSourceNames.stream().filter(n -> !DataSourceUtil.isDefault((String)n)).collect(Collectors.toSet());
        this.generatedBean = generatedBean;
    }

    public void createFlywayProducerBean() {
        ClassCreator classCreator = ClassCreator.builder().classOutput(this::writeGeneratedBeanBuildItem).className(FLYWAY_PRODUCER_TYPE_NAME).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        FieldCreator defaultProducerField = classCreator.getFieldCreator("defaultProducer", FlywayProducer.class);
        defaultProducerField.setModifiers(0);
        defaultProducerField.addAnnotation(Inject.class);
        for (String dataSourceName : this.namedDataSourceNames) {
            String dataSourceFieldName = "dataSource" + FlywayDatasourceBeanGenerator.hashed(dataSourceName);
            FieldCreator dataSourceField = classCreator.getFieldCreator(dataSourceFieldName, DataSource.class);
            dataSourceField.setModifiers(0);
            dataSourceField.addAnnotation(Inject.class);
            dataSourceField.addAnnotation(FlywayDatasourceBeanGenerator.annotatedWithNamed(dataSourceName));
            String producerMethodName = "createFlywayForDataSource" + FlywayDatasourceBeanGenerator.hashed(dataSourceName);
            MethodCreator flywayProducerMethod = classCreator.getMethodCreator(producerMethodName, Flyway.class, new Class[0]);
            flywayProducerMethod.addAnnotation(Produces.class);
            flywayProducerMethod.addAnnotation(Dependent.class);
            flywayProducerMethod.addAnnotation(this.annotatedWithFlywayDatasource(dataSourceName));
            flywayProducerMethod.addAnnotation(FlywayDatasourceBeanGenerator.annotatedWithNamed(FLYWAY_BEAN_NAME_PREFIX + dataSourceName));
            flywayProducerMethod.returnValue(flywayProducerMethod.invokeVirtualMethod(FlywayDatasourceBeanGenerator.createFlywayMethod(), FlywayDatasourceBeanGenerator.resultHandleFor(defaultProducerField, (BytecodeCreator)flywayProducerMethod), new ResultHandle[]{FlywayDatasourceBeanGenerator.resultHandleFor(dataSourceField, (BytecodeCreator)flywayProducerMethod), flywayProducerMethod.load(dataSourceName)}));
        }
        classCreator.close();
    }

    private void writeGeneratedBeanBuildItem(String name, byte[] data) {
        this.generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
    }

    private static String hashed(String dataSourceName) {
        return "_" + HashUtil.sha1((String)dataSourceName);
    }

    private static MethodDescriptor createFlywayMethod() {
        Class[] parameterTypes = new Class[]{DataSource.class, String.class};
        return MethodDescriptor.ofMethod(FlywayProducer.class, (String)"createFlyway", Flyway.class, (Class[])parameterTypes);
    }

    private static ResultHandle resultHandleFor(FieldCreator field, BytecodeCreator method) {
        FieldDescriptor fieldDescriptor = field.getFieldDescriptor();
        return method.readInstanceField(fieldDescriptor, method.getThis());
    }

    private static AnnotationInstance annotatedWithNamed(String dataSourceName) {
        return AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)dataSourceName)});
    }

    private AnnotationInstance annotatedWithFlywayDatasource(String dataSourceName) {
        return AnnotationInstance.create((DotName)DotName.createSimple((String)FlywayDataSource.class.getName()), null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)dataSourceName)});
    }

    public String toString() {
        return "FlywayDatasourceBeanGenerator [dataSourceNames=" + this.namedDataSourceNames + ", generatedBean=" + this.generatedBean + "]";
    }
}

