/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.agroal.deployment.JdbcDataSourceBuildItem;
import io.quarkus.agroal.deployment.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.flyway.FlywayDatasourceBeanGenerator;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayProducer;
import io.quarkus.flyway.runtime.FlywayRecorder;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class FlywayProcessor {
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String JAR_APPLICATION_MIGRATIONS_PROTOCOL = "jar";
    private static final String FILE_APPLICATION_MIGRATIONS_PROTOCOL = "file";
    private static final Logger LOGGER = Logger.getLogger(FlywayProcessor.class);
    FlywayBuildTimeConfig flywayBuildConfig;

    FlywayProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.flyway");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<BeanContainerListenerBuildItem> containerListenerProducer, FlywayRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItem) throws IOException, URISyntaxException {
        featureProducer.produce((BuildItem)new FeatureBuildItem("flyway"));
        AdditionalBeanBuildItem unremovableProducer = AdditionalBeanBuildItem.unremovableOf(FlywayProducer.class);
        additionalBeanProducer.produce((BuildItem)unremovableProducer);
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        new FlywayDatasourceBeanGenerator(dataSourceNames, generatedBeanBuildItem).createFlywayProducerBean();
        List<String> applicationMigrations = this.discoverApplicationMigrations(this.getMigrationLocations(dataSourceNames));
        recorder.setApplicationMigrationFiles(applicationMigrations);
        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(applicationMigrations.toArray(new String[0])));
        containerListenerProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.setFlywayBuildConfig(this.flywayBuildConfig)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem configureRuntimeProperties(FlywayRecorder recorder, FlywayRuntimeConfig flywayRuntimeConfig, BeanContainerBuildItem beanContainer, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        recorder.configureFlywayProperties(flywayRuntimeConfig, beanContainer.getValue());
        recorder.doStartActions(flywayRuntimeConfig, beanContainer.getValue());
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(dataSourceNames));
        return new ServiceStartBuildItem("flyway");
    }

    private Collection<String> getMigrationLocations(Collection<String> dataSourceNames) {
        Collection migrationLocations = dataSourceNames.stream().map(arg_0 -> ((FlywayBuildTimeConfig)this.flywayBuildConfig).getConfigForDataSourceName(arg_0)).flatMap(config -> config.locations.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        if (DataSourceUtil.hasDefault(dataSourceNames)) {
            migrationLocations.addAll(this.flywayBuildConfig.defaultDataSource.locations);
        }
        return migrationLocations;
    }

    private List<String> discoverApplicationMigrations(Collection<String> locations) throws IOException, URISyntaxException {
        ArrayList<String> applicationMigrationResources = new ArrayList<String>();
        for (String location : locations) {
            if (location != null && location.startsWith("classpath:")) {
                location = location.substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1);
            }
            Enumeration<URL> migrations = Thread.currentThread().getContextClassLoader().getResources(location);
            while (migrations.hasMoreElements()) {
                Set<String> applicationMigrations;
                URL path = migrations.nextElement();
                LOGGER.infov("Adding application migrations in path ''{0}'' using protocol ''{1}''", (Object)path.getPath(), (Object)path.getProtocol());
                if (JAR_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    try (FileSystem fileSystem = this.initFileSystem(path.toURI());){
                        applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                    }
                } else if (FILE_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                } else {
                    LOGGER.warnv("Unsupported URL protocol ''{0}'' for path ''{1}''. Migration files will not be discovered.", (Object)path.getProtocol(), (Object)path.getPath());
                    applicationMigrations = null;
                }
                if (applicationMigrations == null) continue;
                applicationMigrationResources.addAll(applicationMigrations);
            }
        }
        return applicationMigrationResources;
    }

    private Set<String> getApplicationMigrationsFromPath(String location, URL path) throws IOException, URISyntaxException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(path.toURI()), new FileVisitOption[0]);){
            Set<String> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> Paths.get(location, it.getFileName().toString()).toString()).peek(it -> LOGGER.debug((Object)("Discovered: " + it))).collect(Collectors.toSet());
            return set;
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        return FileSystems.newFileSystem(uri, env);
    }
}

