/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import java.util.function.BiFunction;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ScannerTransformer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    static final String FLYWAY_SCANNER_CLASS_NAME = Scanner.class.getName();
    private static final String FLYWAY_SCANNER_INTERNAL_CLASS_NAME = FLYWAY_SCANNER_CLASS_NAME.replace('.', '/');
    private static final String FLYWAY_RESOURCE_AND_CLASS_SCANNER_CLASS_NAME = ResourceAndClassScanner.class.getName();
    private static final String FLYWAY_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME = FLYWAY_RESOURCE_AND_CLASS_SCANNER_CLASS_NAME.replace('.', '/');
    private static final String QUARKUS_RESOURCE_AND_CLASS_SCANNER_CLASS_NAME = QuarkusPathLocationScanner.class.getName();
    private static final String QUARKUS_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME = QUARKUS_RESOURCE_AND_CLASS_SCANNER_CLASS_NAME.replace('.', '/');
    private static final String CTOR_METHOD_NAME = "<init>";

    ScannerTransformer() {
    }

    @Override
    public ClassVisitor apply(String s, ClassVisitor cv) {
        return new ScannerVisitor(cv);
    }

    private static final class ScannerVisitor
    extends ClassVisitor {
        public ScannerVisitor(ClassVisitor cv) {
            super(524288, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals(ScannerTransformer.CTOR_METHOD_NAME)) {
                return new ConstructorTransformer(mv);
            }
            return mv;
        }

        private static class ConstructorTransformer
        extends MethodVisitor {
            public ConstructorTransformer(MethodVisitor mv) {
                super(524288, mv);
            }

            public void visitCode() {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(183, "java/lang/Object", ScannerTransformer.CTOR_METHOD_NAME, "()V", false);
                super.visitVarInsn(25, 0);
                super.visitTypeInsn(187, "java/util/ArrayList");
                super.visitInsn(89);
                super.visitMethodInsn(183, "java/util/ArrayList", ScannerTransformer.CTOR_METHOD_NAME, "()V", false);
                super.visitFieldInsn(181, FLYWAY_SCANNER_INTERNAL_CLASS_NAME, "resources", "Ljava/util/List;");
                super.visitVarInsn(25, 0);
                super.visitTypeInsn(187, "java/util/ArrayList");
                super.visitInsn(89);
                super.visitMethodInsn(183, "java/util/ArrayList", ScannerTransformer.CTOR_METHOD_NAME, "()V", false);
                super.visitFieldInsn(181, FLYWAY_SCANNER_INTERNAL_CLASS_NAME, "classes", "Ljava/util/List;");
                super.visitTypeInsn(187, QUARKUS_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME);
                super.visitInsn(89);
                super.visitVarInsn(25, 2);
                super.visitMethodInsn(183, QUARKUS_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME, ScannerTransformer.CTOR_METHOD_NAME, "(Ljava/util/Collection;)V", false);
                super.visitVarInsn(58, 7);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, FLYWAY_SCANNER_INTERNAL_CLASS_NAME, "resources", "Ljava/util/List;");
                super.visitVarInsn(25, 7);
                super.visitMethodInsn(185, FLYWAY_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME, "scanForResources", "()Ljava/util/Collection;", true);
                super.visitMethodInsn(185, "java/util/List", "addAll", "(Ljava/util/Collection;)Z", true);
                super.visitInsn(87);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, FLYWAY_SCANNER_INTERNAL_CLASS_NAME, "classes", "Ljava/util/List;");
                super.visitVarInsn(25, 7);
                super.visitMethodInsn(185, FLYWAY_RESOURCE_AND_CLASS_SCANNER_INTERNAL_CLASS_NAME, "scanForClasses", "()Ljava/util/Collection;", true);
                super.visitMethodInsn(185, "java/util/List", "addAll", "(Ljava/util/Collection;)Z", true);
                super.visitInsn(87);
                super.visitInsn(177);
                super.visitMaxs(3, 8);
            }
        }
    }
}

