/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.deployment;

import io.quarkus.agroal.deployment.AgroalDataSourceBuildUtil;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.builditem.InitTaskCompletedBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.deployment.FlywayCallbacksLocator;
import io.quarkus.flyway.deployment.FlywayEnabled;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayRecorder;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.runtime.util.ClassPathUtils;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={FlywayEnabled.class})
class FlywayProcessor {
    private static final String MODEL_CLASS_SUFFIX = "Model";
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String FLYWAY_CONTAINER_BEAN_NAME_PREFIX = "flyway_container_";
    private static final String FLYWAY_BEAN_NAME_PREFIX = "flyway_";
    private static final DotName JAVA_MIGRATION = DotName.createSimple((String)JavaMigration.class.getName());
    private static final Logger LOGGER = Logger.getLogger(FlywayProcessor.class);

    FlywayProcessor() {
    }

    @BuildStep
    void reflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyProducer) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ConfigurationExtension.class}).reason(this.getClass().getName()).fields().methods().build());
        for (ClassInfo configurationExtension : index.getIndex().getAllKnownImplementors(ConfigurationExtension.class)) {
            DotName extensionName = configurationExtension.name();
            ReflectiveHierarchyBuildItem reflectiveHierarchyItem = ReflectiveHierarchyBuildItem.builder((DotName)extensionName).ignoreTypePredicate(type -> !extensionName.equals(type) && !type.toString().endsWith(MODEL_CLASS_SUFFIX)).ignoreMethodPredicate(m -> !extensionName.equals((Object)m.declaringClass().name())).ignoreFieldPredicate(f -> !extensionName.equals((Object)f.declaringClass().name()) && !f.type().name().toString().endsWith(MODEL_CLASS_SUFFIX)).build();
            reflectiveHierarchyProducer.produce((BuildItem)reflectiveHierarchyItem);
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    MigrationStateBuildItem build(BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentProducer, FlywayRecorder recorder, RecorderContext context, CombinedIndexBuildItem combinedIndexBuildItem, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, FlywayBuildTimeConfig flywayBuildTimeConfig) throws Exception {
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        HashMap<String, Collection<String>> applicationMigrationsToDs = new HashMap<String, Collection<String>>();
        for (String dataSourceName : dataSourceNames) {
            FlywayDataSourceBuildTimeConfig flywayDataSourceBuildTimeConfig = flywayBuildTimeConfig.getConfigForDataSourceName(dataSourceName);
            Collection<String> collection = this.discoverApplicationMigrations(flywayDataSourceBuildTimeConfig.locations);
            applicationMigrationsToDs.put(dataSourceName, collection);
        }
        HashSet<String> datasourcesWithMigrations = new HashSet<String>();
        HashSet<String> datasourcesWithoutMigrations = new HashSet<String>();
        for (Map.Entry entry : applicationMigrationsToDs.entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) {
                datasourcesWithoutMigrations.add((String)entry.getKey());
                continue;
            }
            datasourcesWithMigrations.add((String)entry.getKey());
        }
        Collection applicationMigrations = applicationMigrationsToDs.values().stream().collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
        for (String applicationMigration : applicationMigrations) {
            Location applicationMigrationLocation = new Location(applicationMigration);
            String applicationMigrationPath = applicationMigrationLocation.getPath();
            if (applicationMigrationPath == null || applicationMigrationPath.endsWith(".class")) continue;
            hotDeploymentProducer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(applicationMigrationPath));
        }
        recorder.setApplicationMigrationFiles(applicationMigrations);
        HashSet<Class<? extends JavaMigration>> hashSet = new HashSet<Class<? extends JavaMigration>>();
        this.addJavaMigrations(combinedIndexBuildItem.getIndex().getAllKnownImplementors(JAVA_MIGRATION), context, reflectiveClassProducer, hashSet);
        recorder.setApplicationMigrationClasses(hashSet);
        Map<String, Collection<Callback>> callbacks = FlywayCallbacksLocator.with(dataSourceNames, flywayBuildTimeConfig, combinedIndexBuildItem, reflectiveClassProducer).getCallbacks();
        recorder.setApplicationCallbackClasses(callbacks);
        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(applicationMigrations.toArray(new String[0])));
        return new MigrationStateBuildItem(datasourcesWithMigrations, datasourcesWithoutMigrations);
    }

    private void addJavaMigrations(Collection<ClassInfo> candidates, RecorderContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, Set<Class<? extends JavaMigration>> javaMigrationClasses) {
        for (ClassInfo javaMigration : candidates) {
            if (Modifier.isAbstract(javaMigration.flags())) continue;
            javaMigrationClasses.add(context.classProxy(javaMigration.name().toString()));
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{javaMigration.name().toString()}).build());
        }
    }

    @BuildStep
    @Produce(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Consume(value=LoggingSetupBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBeans(FlywayRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, List<JdbcInitialSQLGeneratorBuildItem> sqlGeneratorBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, MigrationStateBuildItem migrationsBuildItem, FlywayBuildTimeConfig flywayBuildTimeConfig) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{FlywayContainerProducer.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(FlywayDataSource.class).build());
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            AnnotationInstance flywayContainerQualifier;
            boolean hasMigrations = migrationsBuildItem.hasMigrations.contains(dataSourceName);
            boolean createPossible = false;
            if (!hasMigrations) {
                createPossible = sqlGeneratorBuildItems.stream().anyMatch(s -> s.getDatabaseName().equals(dataSourceName));
            }
            SyntheticBeanBuildItem.ExtendedBeanConfigurator flywayContainerConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FlywayContainer.class).scope(Singleton.class)).setRuntimeInit().unremovable()).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(FlywayContainerProducer.class)), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(DataSource.class)), new AnnotationInstance[]{AgroalDataSourceBuildUtil.qualifier((String)dataSourceName)})).startup()).checkActive(recorder.flywayCheckActiveSupplier(dataSourceName)).createWith(recorder.flywayContainerFunction(dataSourceName, hasMigrations, createPossible));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                flywayContainerConfigurator.addQualifier(Default.class);
                flywayContainerConfigurator.priority(10);
                flywayContainerQualifier = AnnotationInstance.builder(Default.class).build();
            } else {
                String beanName = FLYWAY_CONTAINER_BEAN_NAME_PREFIX + dataSourceName;
                flywayContainerConfigurator.name(beanName);
                flywayContainerConfigurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                flywayContainerConfigurator.addQualifier().annotation(FlywayDataSource.class).addValue("value", (Object)dataSourceName).done();
                flywayContainerConfigurator.priority(5);
                flywayContainerQualifier = AnnotationInstance.builder(FlywayDataSource.class).add("value", dataSourceName).build();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)flywayContainerConfigurator.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator flywayConfigurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Flyway.class).scope(Singleton.class)).setRuntimeInit().unremovable()).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(FlywayContainer.class)), new AnnotationInstance[]{flywayContainerQualifier})).startup()).checkActive(recorder.flywayCheckActiveSupplier(dataSourceName)).createWith(recorder.flywayFunction(dataSourceName));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                flywayConfigurator.addQualifier(Default.class);
                flywayConfigurator.priority(10);
            } else {
                String beanName = FLYWAY_BEAN_NAME_PREFIX + dataSourceName;
                flywayConfigurator.name(beanName);
                flywayConfigurator.priority(5);
                flywayConfigurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                flywayConfigurator.addQualifier().annotation(FlywayDataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)flywayConfigurator.done());
        }
    }

    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem startActions(FlywayRecorder recorder, FlywayRuntimeConfig config, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem, BuildProducer<InitTaskCompletedBuildItem> initializationCompleteBuildItem, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, MigrationStateBuildItem migrationsBuildItem) {
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            recorder.doStartActions(dataSourceName);
        }
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(migrationsBuildItem.hasMigrations));
        initializationCompleteBuildItem.produce((BuildItem)new InitTaskCompletedBuildItem("flyway"));
        return new ServiceStartBuildItem("flyway");
    }

    @BuildStep
    public InitTaskBuildItem configureInitTask(ApplicationInfoBuildItem app) {
        return InitTaskBuildItem.create().withName(app.getName() + "-flyway-init").withTaskEnvVars(Map.of("QUARKUS_INIT_AND_EXIT", "true", "QUARKUS_FLYWAY_ACTIVE", "true")).withAppEnvVars(Map.of("QUARKUS_FLYWAY_ACTIVE", "false")).withSharedEnvironment(true).withSharedFilesystem(true);
    }

    private Set<String> getDataSourceNames(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) {
        HashSet<String> result = new HashSet<String>(jdbcDataSourceBuildItems.size());
        for (JdbcDataSourceBuildItem item : jdbcDataSourceBuildItems) {
            result.add(item.getName());
        }
        return result;
    }

    private Collection<String> discoverApplicationMigrations(Collection<String> locations) throws IOException {
        LinkedHashSet<String> applicationMigrationResources = new LinkedHashSet<String>();
        for (String location : locations) {
            if ((location = this.normalizeLocation(location)).startsWith("filesystem:")) {
                applicationMigrationResources.add(location);
                continue;
            }
            String finalLocation = location;
            ClassPathUtils.consumeAsPaths((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)location, path -> {
                Set<String> applicationMigrations = null;
                try {
                    applicationMigrations = this.getApplicationMigrationsFromPath(finalLocation, (Path)path);
                }
                catch (IOException e) {
                    LOGGER.warnv((Throwable)e, "Can't process files in path %s", path);
                }
                if (applicationMigrations != null) {
                    applicationMigrationResources.addAll(applicationMigrations);
                }
            });
        }
        return applicationMigrationResources;
    }

    private String normalizeLocation(String location) {
        if (location == null) {
            throw new IllegalStateException("Flyway migration location may not be null.");
        }
        if (((String)location).startsWith("classpath:") && ((String)(location = ((String)location).substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1))).startsWith("/")) {
            location = ((String)location).substring(1);
        }
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }

    private Set<String> getApplicationMigrationsFromPath(String location, Path rootPath) throws IOException {
        try (Stream<Path> pathStream = Files.walk(rootPath, new FileVisitOption[0]);){
            Set<String> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> Paths.get(location, rootPath.relativize((Path)it).toString()).normalize().toString()).map(it -> it.replace('\\', '/')).peek(it -> LOGGER.debugf("Discovered path: %s", it)).collect(Collectors.toSet());
            return set;
        }
    }

    public static final class MigrationStateBuildItem
    extends SimpleBuildItem {
        final Set<String> hasMigrations;
        final Set<String> missingMigrations;

        MigrationStateBuildItem(Set<String> hasMigrations, Set<String> missingMigrations) {
            this.hasMigrations = hasMigrations;
            this.missingMigrations = missingMigrations;
        }
    }
}

