/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.flyway.runtime.FlywayBuildConfig;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

@ApplicationScoped
public class FlywayProducer {
    @Inject
    AgroalDataSource dataSource;
    private FlywayRuntimeConfig flywayRuntimeConfig;
    private FlywayBuildConfig flywayBuildConfig;

    @Produces
    @Dependent
    public Flyway produceFlyway() {
        FluentConfiguration configure = Flyway.configure();
        configure.dataSource((DataSource)this.dataSource);
        this.flywayRuntimeConfig.connectRetries.ifPresent(arg_0 -> ((FluentConfiguration)configure).connectRetries(arg_0));
        List<String> notEmptySchemas = this.filterBlanks(this.flywayRuntimeConfig.schemas);
        if (!notEmptySchemas.isEmpty()) {
            configure.schemas(notEmptySchemas.toArray(new String[0]));
        }
        this.flywayRuntimeConfig.table.ifPresent(arg_0 -> ((FluentConfiguration)configure).table(arg_0));
        List<String> notEmptyLocations = this.filterBlanks(this.flywayBuildConfig.locations);
        if (!notEmptyLocations.isEmpty()) {
            configure.locations(notEmptyLocations.toArray(new String[0]));
        }
        this.flywayRuntimeConfig.sqlMigrationPrefix.ifPresent(arg_0 -> ((FluentConfiguration)configure).sqlMigrationPrefix(arg_0));
        this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.ifPresent(arg_0 -> ((FluentConfiguration)configure).repeatableSqlMigrationPrefix(arg_0));
        configure.baselineOnMigrate(this.flywayRuntimeConfig.baselineOnMigrate);
        this.flywayRuntimeConfig.baselineVersion.ifPresent(arg_0 -> ((FluentConfiguration)configure).baselineVersion(arg_0));
        this.flywayRuntimeConfig.baselineDescription.ifPresent(arg_0 -> ((FluentConfiguration)configure).baselineDescription(arg_0));
        return configure.load();
    }

    private List<String> filterBlanks(List<String> values) {
        return values.stream().filter(it -> it != null && !"".equals(it)).collect(Collectors.toList());
    }

    public void setFlywayRuntimeConfig(FlywayRuntimeConfig flywayRuntimeConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
    }

    public void setFlywayBuildConfig(FlywayBuildConfig flywayBuildConfig) {
        this.flywayBuildConfig = flywayBuildConfig;
    }
}

