/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayCreator;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;

public class FlywayContainerProducer {
    private final FlywayRuntimeConfig flywayRuntimeConfig;
    private final FlywayBuildTimeConfig flywayBuildConfig;

    public FlywayContainerProducer(FlywayRuntimeConfig flywayRuntimeConfig, FlywayBuildTimeConfig flywayBuildConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildConfig = flywayBuildConfig;
    }

    public FlywayContainer createFlyway(DataSource dataSource, String dataSourceName) {
        FlywayDataSourceRuntimeConfig matchingRuntimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.flywayRuntimeConfig.defaultDataSource : this.flywayRuntimeConfig.getConfigForDataSourceName(dataSourceName);
        FlywayDataSourceBuildTimeConfig matchingBuildTimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.flywayBuildConfig.defaultDataSource : this.flywayBuildConfig.getConfigForDataSourceName(dataSourceName);
        Flyway flyway = new FlywayCreator(matchingRuntimeConfig, matchingBuildTimeConfig).createFlyway(dataSource);
        return new FlywayContainer(flyway, matchingRuntimeConfig.cleanAtStart, matchingRuntimeConfig.migrateAtStart);
    }
}

