/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import org.flywaydb.core.Flyway;

public class FlywayContainer {
    private final Flyway flyway;
    private final boolean cleanAtStart;
    private final boolean migrateAtStart;
    private final String dataSourceName;

    public FlywayContainer(Flyway flyway, boolean cleanAtStart, boolean migrateAtStart, String dataSourceName) {
        this.flyway = flyway;
        this.cleanAtStart = cleanAtStart;
        this.migrateAtStart = migrateAtStart;
        this.dataSourceName = dataSourceName;
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    public boolean isCleanAtStart() {
        return this.cleanAtStart;
    }

    public boolean isMigrateAtStart() {
        return this.migrateAtStart;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getEffectiveDataSourceName() {
        if (DataSourceUtil.isDefault((String)this.dataSourceName)) {
            return "default";
        }
        return this.dataSourceName;
    }
}

