/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;
import org.jboss.logging.Logger;

public final class QuarkusPathLocationScanner
implements ResourceAndClassScanner {
    private static final Logger LOGGER = Logger.getLogger(QuarkusPathLocationScanner.class);
    private static final String LOCATION_SEPARATOR = "/";
    private static Collection<String> applicationMigrationFiles = Collections.emptyList();
    private static Collection<Class<? extends JavaMigration>> applicationMigrationClasses = Collections.emptyList();
    private static Map<String, Collection<Callback>> applicationCallbackClasses = Collections.emptyMap();
    private final Collection<LoadableResource> scannedResources;

    public QuarkusPathLocationScanner(Collection<Location> locations) {
        LOGGER.debugv("Locations: {0}", locations);
        this.scannedResources = new ArrayList<LoadableResource>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FileSystemScanner fileSystemScanner = null;
        for (String migrationFile : applicationMigrationFiles) {
            if (this.isClassPathResource(locations, migrationFile)) {
                LOGGER.debugf("Loading %s", (Object)migrationFile);
                this.scannedResources.add((LoadableResource)new ClassPathResource(null, migrationFile, classLoader, StandardCharsets.UTF_8));
                continue;
            }
            if (!migrationFile.startsWith("filesystem:")) continue;
            if (fileSystemScanner == null) {
                fileSystemScanner = new FileSystemScanner(StandardCharsets.UTF_8, false);
            }
            LOGGER.debugf("Checking %s for migration files", (Object)migrationFile);
            Collection resources = fileSystemScanner.scanForResources(new Location(migrationFile));
            LOGGER.debugf("%s contains %d migration files", (Object)migrationFile, (Object)resources.size());
            this.scannedResources.addAll(resources);
        }
    }

    public static void setApplicationCallbackClasses(Map<String, Collection<Callback>> callbackClasses) {
        applicationCallbackClasses = callbackClasses;
    }

    public static Collection<Callback> callbacksForDataSource(String dsName) {
        return applicationCallbackClasses.getOrDefault(dsName, Collections.emptyList());
    }

    public Collection<LoadableResource> scanForResources() {
        return this.scannedResources;
    }

    private boolean isClassPathResource(Collection<Location> locations, String migrationFile) {
        for (Location location : locations) {
            String locationPath = location.getPath();
            if (!locationPath.endsWith(LOCATION_SEPARATOR)) {
                locationPath = locationPath + LOCATION_SEPARATOR;
            }
            if (migrationFile.startsWith(locationPath)) {
                return true;
            }
            LOGGER.debugf("Migration file '%s' will be ignored because it does not start with '%s'", (Object)migrationFile, (Object)locationPath);
        }
        return false;
    }

    public Collection<Class<? extends JavaMigration>> scanForClasses() {
        return applicationMigrationClasses;
    }

    public static void setApplicationMigrationFiles(Collection<String> applicationMigrationFiles) {
        QuarkusPathLocationScanner.applicationMigrationFiles = applicationMigrationFiles;
    }

    public static void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> applicationMigrationClasses) {
        QuarkusPathLocationScanner.applicationMigrationClasses = applicationMigrationClasses;
    }
}

