/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.sql.Connection;
import java.util.function.BooleanSupplier;
import org.flywaydb.core.api.configuration.Configuration;

@TargetClass(className="org.flywaydb.core.internal.database.oracle.OracleDatabaseType", onlyWith={IsOracleDriverAbsent.class})
public final class OracleDatabaseTypeSubstitutions {
    @Substitute
    public Connection alterConnectionAsNeeded(Connection connection, Configuration configuration) {
        return connection;
    }

    static final class IsOracleDriverAbsent
    implements BooleanSupplier {
        IsOracleDriverAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName("oracle.jdbc.OracleConnection");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
    }
}

