/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.FlywayProducer;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.flyway.runtime.graal.QuarkusPathLocationScanner;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Default;
import javax.enterprise.util.AnnotationLiteral;
import org.flywaydb.core.Flyway;

@Recorder
public class FlywayRecorder {
    public void setApplicationMigrationFiles(List<String> migrationFiles) {
        QuarkusPathLocationScanner.setApplicationMigrationFiles(migrationFiles);
    }

    public BeanContainerListener setFlywayBuildConfig(FlywayBuildTimeConfig flywayBuildConfig) {
        return beanContainer -> {
            FlywayProducer producer = (FlywayProducer)beanContainer.instance(FlywayProducer.class, new Annotation[0]);
            producer.setFlywayBuildConfig(flywayBuildConfig);
        };
    }

    public void configureFlywayProperties(FlywayRuntimeConfig flywayRuntimeConfig, BeanContainer container) {
        ((FlywayProducer)container.instance(FlywayProducer.class, new Annotation[0])).setFlywayRuntimeConfig(flywayRuntimeConfig);
    }

    public void doStartActions(FlywayRuntimeConfig config, BeanContainer container) {
        if (config.defaultDataSource.cleanAtStart) {
            this.clean(container, (AnnotationLiteral<? extends Annotation>)Default.Literal.INSTANCE);
        }
        if (config.defaultDataSource.migrateAtStart) {
            this.migrate(container, (AnnotationLiteral<? extends Annotation>)Default.Literal.INSTANCE);
        }
        for (Map.Entry<String, FlywayDataSourceRuntimeConfig> configPerDataSource : config.namedDataSources.entrySet()) {
            if (configPerDataSource.getValue().cleanAtStart) {
                this.clean(container, FlywayDataSource.FlywayDataSourceLiteral.of(configPerDataSource.getKey()));
            }
            if (!configPerDataSource.getValue().migrateAtStart) continue;
            this.migrate(container, FlywayDataSource.FlywayDataSourceLiteral.of(configPerDataSource.getKey()));
        }
    }

    private void clean(BeanContainer container, AnnotationLiteral<? extends Annotation> qualifier) {
        ((Flyway)container.instance(Flyway.class, new Annotation[]{qualifier})).clean();
    }

    private void migrate(BeanContainer container, AnnotationLiteral<? extends Annotation> qualifier) {
        ((Flyway)container.instance(Flyway.class, new Annotation[]{qualifier})).migrate();
    }
}

