/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.java.FixedJavaMigrationResolver;
import org.flywaydb.core.internal.resolver.java.ScanningJavaMigrationResolver;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

@TargetClass(className="org.flywaydb.core.internal.resolver.CompositeMigrationResolver")
public final class CompositeMigrationResolverSubstitutions {
    @Alias
    private Collection<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();

    @Substitute
    public CompositeMigrationResolverSubstitutions(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext, MigrationResolver ... customMigrationResolvers) {
        if (!configuration.isSkipDefaultResolvers()) {
            this.migrationResolvers.add((MigrationResolver)new SqlMigrationResolver(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, configuration, parsingContext));
            this.migrationResolvers.add((MigrationResolver)new ScanningJavaMigrationResolver(classProvider, configuration));
        }
        this.migrationResolvers.add((MigrationResolver)new FixedJavaMigrationResolver(configuration.getJavaMigrations()));
        this.migrationResolvers.addAll(Arrays.asList(customMigrationResolvers));
    }
}

