/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.jboss.logging.Logger;

public final class QuarkusPathLocationScanner
implements ResourceAndClassScanner {
    private static final Logger LOGGER = Logger.getLogger(QuarkusPathLocationScanner.class);
    private static final String LOCATION_SEPARATOR = "/";
    private static List<String> applicationMigrationFiles;
    private final Collection<LoadableResource> scannedResources = new ArrayList<LoadableResource>();

    public QuarkusPathLocationScanner(Collection<Location> locations) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String migrationFile : applicationMigrationFiles) {
            if (!this.canHandleMigrationFile(locations, migrationFile)) continue;
            LOGGER.debugf("Loading %s", (Object)migrationFile);
            this.scannedResources.add((LoadableResource)new ClassPathResource(null, migrationFile, classLoader, StandardCharsets.UTF_8));
        }
    }

    public Collection<LoadableResource> scanForResources() {
        return this.scannedResources;
    }

    private boolean canHandleMigrationFile(Collection<Location> locations, String migrationFile) {
        for (Location location : locations) {
            String locationPath = location.getPath();
            if (!locationPath.endsWith(LOCATION_SEPARATOR)) {
                locationPath = locationPath + LOCATION_SEPARATOR;
            }
            if (!migrationFile.startsWith(locationPath)) continue;
            return true;
        }
        return false;
    }

    public Collection<Class<?>> scanForClasses() {
        return Collections.emptyList();
    }

    public static void setApplicationMigrationFiles(List<String> applicationMigrationFiles) {
        QuarkusPathLocationScanner.applicationMigrationFiles = applicationMigrationFiles;
    }
}

