/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

class FlywayCreator {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final FlywayDataSourceRuntimeConfig flywayRuntimeConfig;
    private final FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig;

    public FlywayCreator(FlywayDataSourceRuntimeConfig flywayRuntimeConfig, FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildTimeConfig = flywayBuildTimeConfig;
    }

    public Flyway createFlyway(DataSource dataSource) {
        FluentConfiguration configure = Flyway.configure();
        configure.dataSource(dataSource);
        this.flywayRuntimeConfig.connectRetries.ifPresent(arg_0 -> ((FluentConfiguration)configure).connectRetries(arg_0));
        this.flywayRuntimeConfig.schemas.ifPresent(list -> configure.schemas(list.toArray(EMPTY_ARRAY)));
        this.flywayRuntimeConfig.table.ifPresent(arg_0 -> ((FluentConfiguration)configure).table(arg_0));
        configure.locations(this.flywayBuildTimeConfig.locations.toArray(EMPTY_ARRAY));
        this.flywayRuntimeConfig.sqlMigrationPrefix.ifPresent(arg_0 -> ((FluentConfiguration)configure).sqlMigrationPrefix(arg_0));
        this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.ifPresent(arg_0 -> ((FluentConfiguration)configure).repeatableSqlMigrationPrefix(arg_0));
        configure.baselineOnMigrate(this.flywayRuntimeConfig.baselineOnMigrate);
        configure.validateOnMigrate(this.flywayRuntimeConfig.validateOnMigrate);
        configure.outOfOrder(this.flywayRuntimeConfig.outOfOrder);
        this.flywayRuntimeConfig.baselineVersion.ifPresent(arg_0 -> ((FluentConfiguration)configure).baselineVersion(arg_0));
        this.flywayRuntimeConfig.baselineDescription.ifPresent(arg_0 -> ((FluentConfiguration)configure).baselineDescription(arg_0));
        configure.placeholders(this.flywayRuntimeConfig.placeholders);
        return configure.load();
    }
}

