/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

class FlywayCreator {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final FlywayDataSourceRuntimeConfig flywayRuntimeConfig;
    private final FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig;

    public FlywayCreator(FlywayDataSourceRuntimeConfig flywayRuntimeConfig, FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildTimeConfig = flywayBuildTimeConfig;
    }

    public Flyway createFlyway(DataSource dataSource) {
        FluentConfiguration configure = Flyway.configure();
        configure.dataSource(dataSource);
        if (this.flywayRuntimeConfig.connectRetries.isPresent()) {
            configure.connectRetries(this.flywayRuntimeConfig.connectRetries.getAsInt());
        }
        if (this.flywayRuntimeConfig.schemas.isPresent()) {
            configure.schemas(this.flywayRuntimeConfig.schemas.get().toArray(EMPTY_ARRAY));
        }
        if (this.flywayRuntimeConfig.table.isPresent()) {
            configure.table(this.flywayRuntimeConfig.table.get());
        }
        configure.locations(this.flywayBuildTimeConfig.locations.toArray(EMPTY_ARRAY));
        if (this.flywayRuntimeConfig.sqlMigrationPrefix.isPresent()) {
            configure.sqlMigrationPrefix(this.flywayRuntimeConfig.sqlMigrationPrefix.get());
        }
        if (this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.isPresent()) {
            configure.repeatableSqlMigrationPrefix(this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.get());
        }
        configure.baselineOnMigrate(this.flywayRuntimeConfig.baselineOnMigrate);
        configure.validateOnMigrate(this.flywayRuntimeConfig.validateOnMigrate);
        configure.outOfOrder(this.flywayRuntimeConfig.outOfOrder);
        if (this.flywayRuntimeConfig.baselineVersion.isPresent()) {
            configure.baselineVersion(this.flywayRuntimeConfig.baselineVersion.get());
        }
        if (this.flywayRuntimeConfig.baselineDescription.isPresent()) {
            configure.baselineDescription(this.flywayRuntimeConfig.baselineDescription.get());
        }
        configure.placeholders(this.flywayRuntimeConfig.placeholders);
        return configure.load();
    }
}

