/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import org.flywaydb.core.Flyway;

public class FlywayContainer {
    private final Flyway flyway;
    private final boolean cleanAtStart;
    private final boolean migrateAtStart;
    private final boolean repairAtStart;
    private final String dataSourceName;
    private final boolean hasMigrations;
    private final boolean createPossible;
    private final String id;

    public FlywayContainer(Flyway flyway, boolean cleanAtStart, boolean migrateAtStart, boolean repairAtStart, String dataSourceName, boolean hasMigrations, boolean createPossible) {
        this.flyway = flyway;
        this.cleanAtStart = cleanAtStart;
        this.migrateAtStart = migrateAtStart;
        this.repairAtStart = repairAtStart;
        this.dataSourceName = dataSourceName;
        this.hasMigrations = hasMigrations;
        this.createPossible = createPossible;
        this.id = dataSourceName.replace("<", "").replace(">", "");
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    public boolean isCleanAtStart() {
        return this.cleanAtStart;
    }

    public boolean isMigrateAtStart() {
        return this.migrateAtStart;
    }

    public boolean isRepairAtStart() {
        return this.repairAtStart;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean isHasMigrations() {
        return this.hasMigrations;
    }

    public boolean isCreatePossible() {
        return this.createPossible;
    }

    public String getId() {
        return this.id;
    }
}

