/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.jboss.logging.Logger;

@Recorder
public class FlywayRecorder {
    private static final Logger log = Logger.getLogger(FlywayRecorder.class);
    static final List<FlywayContainer> FLYWAY_CONTAINERS = new ArrayList<FlywayContainer>(2);

    public void setApplicationMigrationFiles(Collection<String> migrationFiles) {
        log.debugv("Setting the following application migration files: {0}", migrationFiles);
        QuarkusPathLocationScanner.setApplicationMigrationFiles(migrationFiles);
    }

    public void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> migrationClasses) {
        log.debugv("Setting the following application migration classes: {0}", migrationClasses);
        QuarkusPathLocationScanner.setApplicationMigrationClasses(migrationClasses);
    }

    public void setApplicationCallbackClasses(Map<String, Collection<Callback>> callbackClasses) {
        log.debugv("Setting application callbacks: {0} total", (Object)callbackClasses.values().size());
        QuarkusPathLocationScanner.setApplicationCallbackClasses(callbackClasses);
    }

    public void resetFlywayContainers() {
        FLYWAY_CONTAINERS.clear();
    }

    public Supplier<Flyway> flywaySupplier(String dataSourceName, boolean hasMigrations, boolean createPossible) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        if (dataSource instanceof UnconfiguredDataSource) {
            return new Supplier<Flyway>(){

                @Override
                public Flyway get() {
                    throw new UnsatisfiedResolutionException("No datasource present");
                }
            };
        }
        FlywayContainerProducer flywayProducer = (FlywayContainerProducer)Arc.container().instance(FlywayContainerProducer.class, new Annotation[0]).get();
        final FlywayContainer flywayContainer = flywayProducer.createFlyway((DataSource)dataSource, dataSourceName, hasMigrations, createPossible);
        FLYWAY_CONTAINERS.add(flywayContainer);
        return new Supplier<Flyway>(){

            @Override
            public Flyway get() {
                return flywayContainer.getFlyway();
            }
        };
    }

    public void doStartActions() {
        for (FlywayContainer flywayContainer : FLYWAY_CONTAINERS) {
            if (flywayContainer.isCleanAtStart()) {
                flywayContainer.getFlyway().clean();
            }
            if (flywayContainer.isValidateAtStart()) {
                flywayContainer.getFlyway().validate();
            }
            if (flywayContainer.isRepairAtStart()) {
                flywayContainer.getFlyway().repair();
            }
            if (!flywayContainer.isMigrateAtStart()) continue;
            flywayContainer.getFlyway().migrate();
        }
    }
}

