/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayCreator;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import java.util.Collection;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;

public class FlywayContainerProducer {
    private final FlywayRuntimeConfig flywayRuntimeConfig;
    private final FlywayBuildTimeConfig flywayBuildConfig;

    public FlywayContainerProducer(FlywayRuntimeConfig flywayRuntimeConfig, FlywayBuildTimeConfig flywayBuildConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildConfig = flywayBuildConfig;
    }

    public FlywayContainer createFlyway(DataSource dataSource, String dataSourceName, boolean hasMigrations, boolean createPossible) {
        FlywayDataSourceRuntimeConfig matchingRuntimeConfig = this.flywayRuntimeConfig.getConfigForDataSourceName(dataSourceName);
        FlywayDataSourceBuildTimeConfig matchingBuildTimeConfig = this.flywayBuildConfig.getConfigForDataSourceName(dataSourceName);
        Collection<Callback> callbacks = QuarkusPathLocationScanner.callbacksForDataSource(dataSourceName);
        Flyway flyway = new FlywayCreator(matchingRuntimeConfig, matchingBuildTimeConfig).withCallbacks(callbacks).createFlyway(dataSource);
        return new FlywayContainer(flyway, matchingRuntimeConfig.cleanAtStart, matchingRuntimeConfig.migrateAtStart, matchingRuntimeConfig.repairAtStart, matchingRuntimeConfig.validateAtStart, dataSourceName, hasMigrations, createPossible);
    }
}

