/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayRecorder;
import java.util.ArrayList;
import java.util.Collection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.util.StringUtils;
import org.jboss.logging.Logger;

public class QuarkusFlywayResourceProvider
implements ResourceProvider {
    private static final Logger log = Logger.getLogger(FlywayRecorder.class);
    private final Collection<LoadableResource> resources;

    public QuarkusFlywayResourceProvider(Collection<LoadableResource> resources) {
        this.resources = resources;
    }

    public LoadableResource getResource(String name) {
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getRelativePath();
            if (!fileName.equals(name)) continue;
            return resource;
        }
        return null;
    }

    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith((String)fileName, (String)prefix, (String[])suffixes)) {
                result.add(resource);
                continue;
            }
            log.debug((Object)("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")"));
        }
        return result;
    }
}

