/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.flyway.FlywayConfigurationCustomizer;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusFlywayClassProvider;
import io.quarkus.flyway.runtime.QuarkusFlywayResourceProvider;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;

class FlywayCreator {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final FlywayDataSourceRuntimeConfig flywayRuntimeConfig;
    private final FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig;
    private final List<FlywayConfigurationCustomizer> customizers;
    private Collection<Callback> callbacks = Collections.emptyList();

    public FlywayCreator(FlywayDataSourceRuntimeConfig flywayRuntimeConfig, FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildTimeConfig = flywayBuildTimeConfig;
        this.customizers = Collections.emptyList();
    }

    public FlywayCreator(FlywayDataSourceRuntimeConfig flywayRuntimeConfig, FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig, List<FlywayConfigurationCustomizer> customizers) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildTimeConfig = flywayBuildTimeConfig;
        this.customizers = customizers;
    }

    public FlywayCreator withCallbacks(Collection<Callback> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Flyway createFlyway(DataSource dataSource) {
        String[] ignoreMigrationPatterns;
        FluentConfiguration configure = Flyway.configure();
        if (this.flywayRuntimeConfig.jdbcUrl.isPresent()) {
            if (!this.flywayRuntimeConfig.username.isPresent() || !this.flywayRuntimeConfig.password.isPresent()) throw new ConfigurationException("Username and password must be defined when a JDBC URL is provided in the Flyway configuration");
            configure.dataSource(this.flywayRuntimeConfig.jdbcUrl.get(), this.flywayRuntimeConfig.username.get(), this.flywayRuntimeConfig.password.get());
        } else if (this.flywayRuntimeConfig.username.isPresent() && this.flywayRuntimeConfig.password.isPresent()) {
            AgroalDataSource agroalDataSource = (AgroalDataSource)dataSource;
            String jdbcUrl = agroalDataSource.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
            configure.dataSource(jdbcUrl, this.flywayRuntimeConfig.username.get(), this.flywayRuntimeConfig.password.get());
        } else {
            configure.dataSource(dataSource);
        }
        if (this.flywayRuntimeConfig.initSql.isPresent()) {
            configure.initSql(this.flywayRuntimeConfig.initSql.get());
        }
        if (this.flywayRuntimeConfig.connectRetries.isPresent()) {
            configure.connectRetries(this.flywayRuntimeConfig.connectRetries.getAsInt());
        }
        if (this.flywayRuntimeConfig.defaultSchema.isPresent()) {
            configure.defaultSchema(this.flywayRuntimeConfig.defaultSchema.get());
        }
        if (this.flywayRuntimeConfig.schemas.isPresent()) {
            configure.schemas(this.flywayRuntimeConfig.schemas.get().toArray(EMPTY_ARRAY));
        }
        if (this.flywayRuntimeConfig.table.isPresent()) {
            configure.table(this.flywayRuntimeConfig.table.get());
        }
        configure.locations(this.flywayBuildTimeConfig.locations.toArray(EMPTY_ARRAY));
        if (this.flywayRuntimeConfig.sqlMigrationPrefix.isPresent()) {
            configure.sqlMigrationPrefix(this.flywayRuntimeConfig.sqlMigrationPrefix.get());
        }
        if (this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.isPresent()) {
            configure.repeatableSqlMigrationPrefix(this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.get());
        }
        configure.cleanDisabled(this.flywayRuntimeConfig.cleanDisabled);
        configure.baselineOnMigrate(this.flywayRuntimeConfig.baselineOnMigrate);
        configure.validateOnMigrate(this.flywayRuntimeConfig.validateOnMigrate);
        configure.validateMigrationNaming(this.flywayRuntimeConfig.validateMigrationNaming);
        if (this.flywayRuntimeConfig.ignoreMigrationPatterns.isPresent()) {
            ignoreMigrationPatterns = this.flywayRuntimeConfig.ignoreMigrationPatterns.get();
        } else {
            ArrayList<String> patterns = new ArrayList<String>(2);
            if (this.flywayRuntimeConfig.ignoreMissingMigrations) {
                patterns.add("*:Missing");
            }
            if (this.flywayRuntimeConfig.ignoreFutureMigrations) {
                patterns.add("*:Future");
            }
            ignoreMigrationPatterns = patterns.toArray(new String[0]);
        }
        configure.ignoreMigrationPatterns(ignoreMigrationPatterns);
        configure.cleanOnValidationError(this.flywayRuntimeConfig.cleanOnValidationError);
        configure.outOfOrder(this.flywayRuntimeConfig.outOfOrder);
        if (this.flywayRuntimeConfig.baselineVersion.isPresent()) {
            configure.baselineVersion(this.flywayRuntimeConfig.baselineVersion.get());
        }
        if (this.flywayRuntimeConfig.baselineDescription.isPresent()) {
            configure.baselineDescription(this.flywayRuntimeConfig.baselineDescription.get());
        }
        configure.placeholders(this.flywayRuntimeConfig.placeholders);
        configure.createSchemas(this.flywayRuntimeConfig.createSchemas);
        if (this.flywayRuntimeConfig.placeholderPrefix.isPresent()) {
            configure.placeholderPrefix(this.flywayRuntimeConfig.placeholderPrefix.get());
        }
        if (this.flywayRuntimeConfig.placeholderSuffix.isPresent()) {
            configure.placeholderSuffix(this.flywayRuntimeConfig.placeholderSuffix.get());
        }
        if (!this.callbacks.isEmpty()) {
            configure.callbacks(this.callbacks.toArray(new Callback[0]));
        }
        QuarkusPathLocationScanner quarkusPathLocationScanner = new QuarkusPathLocationScanner(Arrays.asList(configure.getLocations()));
        configure.javaMigrationClassProvider(new QuarkusFlywayClassProvider(quarkusPathLocationScanner.scanForClasses()));
        configure.resourceProvider((ResourceProvider)new QuarkusFlywayResourceProvider(quarkusPathLocationScanner.scanForResources()));
        for (FlywayConfigurationCustomizer customizer : this.customizers) {
            customizer.customize(configure);
        }
        return configure.load();
    }
}

