/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.devconsole;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainersSupplier;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.flywaydb.core.Flyway;

@Recorder
public class FlywayDevConsoleRecorder {
    public Handler<RoutingContext> datasourcesHandler() {
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) {
                String datasource = form.get("datasource");
                String operation = form.get("operation");
                Object flywayContainers = new FlywayContainersSupplier().get();
                Iterator iterator = flywayContainers.iterator();
                while (iterator.hasNext()) {
                    FlywayContainer flywayContainer = (FlywayContainer)iterator.next();
                    if (!flywayContainer.getDataSourceName().equals(datasource)) continue;
                    Flyway flyway = flywayContainer.getFlyway();
                    if ("clean".equals(operation)) {
                        flyway.clean();
                        this.flashMessage(event, "Database cleaned");
                        return;
                    }
                    if ("migrate".equals(operation)) {
                        flyway.migrate();
                        this.flashMessage(event, "Database migrated");
                        return;
                    }
                    this.flashMessage(event, "Invalid operation: " + operation, FlashScopeUtil.FlashMessageStatus.ERROR);
                    return;
                }
                this.flashMessage(event, "Datasource not found: " + datasource, FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }

    public Handler<RoutingContext> createInitialMigrationHandler(final FlywayBuildTimeConfig buildTimeConfig, final String artifactId, final Map<String, Supplier<String>> initialSqlSuppliers, final boolean isBaselineOnMigrateConfigured, final boolean isMigrateAtStartConfigured, final boolean isCleanAtStartConfigured) {
        return new DevConsolePostHandler(){

            protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
                String name = form.get("datasource");
                Supplier found = (Supplier)initialSqlSuppliers.get(name);
                if (found == null) {
                    this.flashMessage(event, "Unable to find SQL generator");
                    return;
                }
                FlywayDataSourceBuildTimeConfig config = buildTimeConfig.getConfigForDataSourceName(name);
                if (config.locations.isEmpty()) {
                    this.flashMessage(event, "Datasource has no locations configured");
                    return;
                }
                List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
                if (resourcesDir.isEmpty()) {
                    this.flashMessage(event, "No resource directory found");
                    return;
                }
                Path path = (Path)resourcesDir.get(0);
                Path migrationDir = path.resolve(config.locations.get(0));
                Files.createDirectories(migrationDir, new FileAttribute[0]);
                Path file = migrationDir.resolve("V1.0.0__" + artifactId + ".sql");
                Files.writeString(file, (CharSequence)found.get(), new OpenOption[0]);
                this.flashMessage(event, file + " was created");
                HashMap<Object, String> newConfig = new HashMap<Object, String>();
                if (!isBaselineOnMigrateConfigured) {
                    newConfig.put("quarkus.flyway.baseline-on-migrate", "true");
                }
                if (!isMigrateAtStartConfigured) {
                    newConfig.put("quarkus.flyway.migrate-at-start", "true");
                }
                for (String profile : List.of("test", "dev")) {
                    if (isCleanAtStartConfigured) continue;
                    newConfig.put("%" + profile + ".quarkus.flyway.clean-at-start", "true");
                }
                CurrentConfig.EDITOR.accept(newConfig);
                DevConsoleManager.getHotReplacementContext().doScan(true);
                this.flashMessage(event, "Initial migration created, Flyway will now manage this datasource");
                event.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).headers().set((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)event.request().absoluteURI().replace("create-initial-migration", "datasources"));
                event.response().end();
            }
        };
    }
}

