/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Collections;
import java.util.Map;

@ConfigRoot(name="flyway", phase=ConfigPhase.RUN_TIME)
public final class FlywayRuntimeConfig {
    @ConfigItem(name="<<parent>>")
    public FlywayDataSourceRuntimeConfig defaultDataSource = FlywayDataSourceRuntimeConfig.defaultConfig();
    @ConfigItem(name="<<parent>>")
    @ConfigDocMapKey(value="datasource-name")
    @ConfigDocSection
    public Map<String, FlywayDataSourceRuntimeConfig> namedDataSources = Collections.emptyMap();

    public FlywayDataSourceRuntimeConfig getConfigForDataSourceName(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.defaultDataSource;
        }
        return this.namedDataSources.getOrDefault(dataSourceName, FlywayDataSourceRuntimeConfig.defaultConfig());
    }
}

