/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.jboss.logging.Logger;

@Recorder
public class FlywayRecorder {
    private static final Logger log = Logger.getLogger(FlywayRecorder.class);
    private final RuntimeValue<FlywayRuntimeConfig> config;

    public FlywayRecorder(RuntimeValue<FlywayRuntimeConfig> config) {
        this.config = config;
    }

    public void setApplicationMigrationFiles(Collection<String> migrationFiles) {
        log.debugv("Setting the following application migration files: {0}", migrationFiles);
        QuarkusPathLocationScanner.setApplicationMigrationFiles(migrationFiles);
    }

    public void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> migrationClasses) {
        log.debugv("Setting the following application migration classes: {0}", migrationClasses);
        QuarkusPathLocationScanner.setApplicationMigrationClasses(migrationClasses);
    }

    public void setApplicationCallbackClasses(Map<String, Collection<Callback>> callbackClasses) {
        log.debugv("Setting application callbacks: {0} total", (Object)callbackClasses.values().size());
        QuarkusPathLocationScanner.setApplicationCallbackClasses(callbackClasses);
    }

    public Function<SyntheticCreationalContext<FlywayContainer>, FlywayContainer> flywayContainerFunction(final String dataSourceName, final boolean hasMigrations, final boolean createPossible) {
        return new Function<SyntheticCreationalContext<FlywayContainer>, FlywayContainer>(){

            @Override
            public FlywayContainer apply(SyntheticCreationalContext<FlywayContainer> context) {
                AgroalDataSource dataSource = ((DataSources)context.getInjectedReference(DataSources.class, new Annotation[0])).getDataSource(dataSourceName);
                if (dataSource instanceof UnconfiguredDataSource) {
                    throw new UnsatisfiedResolutionException("No datasource present");
                }
                FlywayContainerProducer flywayProducer = (FlywayContainerProducer)context.getInjectedReference(FlywayContainerProducer.class, new Annotation[0]);
                FlywayContainer flywayContainer = flywayProducer.createFlyway((DataSource)dataSource, dataSourceName, hasMigrations, createPossible);
                return flywayContainer;
            }
        };
    }

    public Function<SyntheticCreationalContext<Flyway>, Flyway> flywayFunction(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<Flyway>, Flyway>(){

            @Override
            public Flyway apply(SyntheticCreationalContext<Flyway> context) {
                Object flywayContainerQualifier = DataSourceUtil.isDefault((String)dataSourceName) ? Default.Literal.INSTANCE : FlywayDataSource.FlywayDataSourceLiteral.of(dataSourceName);
                FlywayContainer flywayContainer = (FlywayContainer)context.getInjectedReference(FlywayContainer.class, new Annotation[]{flywayContainerQualifier});
                return flywayContainer.getFlyway();
            }
        };
    }

    public void doStartActions() {
        if (!((FlywayRuntimeConfig)this.config.getValue()).enabled) {
            return;
        }
        for (InstanceHandle flywayContainerHandle : Arc.container().listAll(FlywayContainer.class, new Annotation[0])) {
            FlywayContainer flywayContainer = (FlywayContainer)flywayContainerHandle.get();
            if (flywayContainer.isCleanAtStart()) {
                flywayContainer.getFlyway().clean();
            }
            if (flywayContainer.isValidateAtStart()) {
                flywayContainer.getFlyway().validate();
            }
            if (flywayContainer.isRepairAtStart()) {
                flywayContainer.getFlyway().repair();
            }
            if (!flywayContainer.isMigrateAtStart()) continue;
            flywayContainer.getFlyway().migrate();
        }
    }
}

