/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.quarkus.funqy.lambda.FunqyLambdaBindingRecorder;
import io.quarkus.runtime.Application;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class FunqyStreamHandler
implements RequestStreamHandler {
    protected static final String deploymentStatus;
    protected static boolean started;

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        if (!started) {
            throw new IOException(deploymentStatus);
        }
        FunqyLambdaBindingRecorder.handle(inputStream, outputStream, context);
    }

    static {
        started = false;
        StringWriter error = new StringWriter();
        PrintWriter errorWriter = new PrintWriter((Writer)error, true);
        if (Application.currentApplication() == null) {
            try {
                Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
                String[] args = new String[]{};
                final Application app = (Application)appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        app.stop();
                    }
                });
                app.start(args);
                errorWriter.println("Quarkus bootstrapped successfully.");
                started = true;
            }
            catch (Exception ex) {
                errorWriter.println("Quarkus bootstrap failed.");
                ex.printStackTrace(errorWriter);
            }
        } else {
            errorWriter.println("Quarkus bootstrapped successfully.");
            started = true;
        }
        deploymentStatus = error.toString();
    }
}

