/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.gcp.functions.deployment.bindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.funqy.deployment.FunctionBuildItem;
import io.quarkus.funqy.deployment.FunctionInitializedBuildItem;
import io.quarkus.funqy.gcp.functions.FunqyCloudFunctionsBindingRecorder;
import io.quarkus.funqy.runtime.FunqyConfig;
import io.quarkus.jackson.runtime.ObjectMapperProducer;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class FunqyCloudFunctionsBuildStep {
    private static final String FEATURE_NAME = "funqy-google-cloud-functions";

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep
    public RunTimeConfigurationDefaultBuildItem disableBanner() {
        return new RunTimeConfigurationDefaultBuildItem("quarkus.banner.enabled", "false");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void init(List<FunctionBuildItem> functions, FunqyCloudFunctionsBindingRecorder recorder, Optional<FunctionInitializedBuildItem> hasFunctions, BeanContainerBuildItem beanContainer) throws Exception {
        if (!hasFunctions.isPresent()) {
            return;
        }
        recorder.init(beanContainer.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void choose(FunqyConfig config, FunqyCloudFunctionsBindingRecorder recorder) {
        recorder.chooseInvoker(config);
    }

    @BuildStep
    public void markObjectMapperUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapper.class.getName())));
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapperProducer.class.getName())));
    }
}

