/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.gcp.functions;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.cloud.functions.Context;
import io.cloudevents.CloudEvent;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.funqy.gcp.functions.FunqyRequestImpl;
import io.quarkus.funqy.gcp.functions.FunqyResponseImpl;
import io.quarkus.funqy.runtime.FunctionConstructor;
import io.quarkus.funqy.runtime.FunctionInvoker;
import io.quarkus.funqy.runtime.FunctionRecorder;
import io.quarkus.funqy.runtime.FunqyConfig;
import io.quarkus.funqy.runtime.FunqyServerRequest;
import io.quarkus.funqy.runtime.FunqyServerResponse;
import io.quarkus.funqy.runtime.RequestContext;
import io.quarkus.funqy.runtime.RequestContextImpl;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.lang.annotation.Annotation;

@Recorder
public class FunqyCloudFunctionsBindingRecorder {
    private static FunctionInvoker invoker;
    private static BeanContainer beanContainer;
    private static ObjectMapper objectMapper;
    private static ObjectReader reader;
    private static ObjectWriter writer;

    public void init(BeanContainer bc) {
        beanContainer = bc;
        objectMapper = (ObjectMapper)beanContainer.instance(ObjectMapper.class, new Annotation[0]);
        for (FunctionInvoker invoker : FunctionRecorder.registry.invokers()) {
            if (invoker.hasInput()) {
                JavaType javaInputType = objectMapper.constructType(invoker.getInputType());
                ObjectReader reader = objectMapper.readerFor(javaInputType);
                invoker.getBindingContext().put(ObjectReader.class.getName(), reader);
            }
            if (!invoker.hasOutput()) continue;
            JavaType javaOutputType = objectMapper.constructType(invoker.getOutputType());
            ObjectWriter writer = objectMapper.writerFor(javaOutputType);
            invoker.getBindingContext().put(ObjectWriter.class.getName(), writer);
        }
        FunctionConstructor.CONTAINER = bc;
    }

    public void chooseInvoker(FunqyConfig config) {
        if (config.export.isPresent()) {
            invoker = FunctionRecorder.registry.matchInvoker((String)config.export.get());
            if (invoker == null) {
                throw new RuntimeException("quarkus.funqy.export does not match a function: " + (String)config.export.get());
            }
        } else {
            if (FunctionRecorder.registry.invokers().size() == 0) {
                throw new RuntimeException("There are no functions to process lambda");
            }
            if (FunctionRecorder.registry.invokers().size() > 1) {
                throw new RuntimeException("Too many functions.  You need to set quarkus.funqy.export");
            }
            invoker = (FunctionInvoker)FunctionRecorder.registry.invokers().iterator().next();
        }
        if (invoker.hasInput()) {
            reader = (ObjectReader)invoker.getBindingContext().get(ObjectReader.class.getName());
        }
        if (invoker.hasOutput()) {
            writer = (ObjectWriter)invoker.getBindingContext().get(ObjectWriter.class.getName());
        }
    }

    public static void handle(String event, Context context) {
        try {
            FunqyServerResponse response;
            Object value;
            Object input = null;
            if (invoker.hasInput()) {
                input = reader.readValue(event);
            }
            if ((value = (response = FunqyCloudFunctionsBindingRecorder.dispatch(input)).getOutput().await().indefinitely()) != null) {
                throw new RuntimeException("A background function cannot return a value");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handle(CloudEvent cloudEvent) {
        FunqyServerResponse response = FunqyCloudFunctionsBindingRecorder.dispatch(cloudEvent);
        Object value = response.getOutput().await().indefinitely();
        if (value != null) {
            throw new RuntimeException("A background function cannot return a value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FunqyServerResponse dispatch(Object input) {
        ManagedContext requestContext = beanContainer.requestContext();
        requestContext.activate();
        try {
            FunqyRequestImpl funqyRequest = new FunqyRequestImpl((RequestContext)new RequestContextImpl(), input);
            FunqyResponseImpl funqyResponse = new FunqyResponseImpl();
            invoker.invoke((FunqyServerRequest)funqyRequest, (FunqyServerResponse)funqyResponse);
            FunqyResponseImpl funqyResponseImpl = funqyResponse;
            return funqyResponseImpl;
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }
}

