/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBufInputStream;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.funqy.runtime.FunctionInvoker;
import io.quarkus.funqy.runtime.FunctionRecorder;
import io.quarkus.funqy.runtime.FunqyServerRequest;
import io.quarkus.funqy.runtime.FunqyServerResponse;
import io.quarkus.funqy.runtime.RequestContext;
import io.quarkus.funqy.runtime.RequestContextImpl;
import io.quarkus.funqy.runtime.bindings.http.FunqyRequestImpl;
import io.quarkus.funqy.runtime.bindings.http.FunqyResponseImpl;
import io.quarkus.funqy.runtime.query.QueryReader;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;

public class VertxRequestHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.funqy");
    protected final Vertx vertx;
    protected final String rootPath;
    protected final BeanContainer beanContainer;
    protected final CurrentIdentityAssociation association;
    protected final CurrentVertxRequest currentVertxRequest;
    protected final Executor executor;

    public VertxRequestHandler(Vertx vertx, BeanContainer beanContainer, String rootPath, Executor executor) {
        this.vertx = vertx;
        this.beanContainer = beanContainer;
        this.rootPath = rootPath == null ? "/" : (!rootPath.endsWith("/") ? rootPath + "/" : rootPath);
        this.executor = executor;
        Instance association = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = association.isResolvable() ? (CurrentIdentityAssociation)association.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
    }

    public void handle(final RoutingContext routingContext) {
        String path = routingContext.request().path();
        if (path == null) {
            routingContext.fail(404);
            return;
        }
        if (!path.startsWith(this.rootPath)) {
            routingContext.fail(404);
            return;
        }
        final FunctionInvoker invoker = FunctionRecorder.registry.matchInvoker(path = path.substring(this.rootPath.length()));
        if (invoker == null) {
            routingContext.fail(404);
            return;
        }
        if (routingContext.request().method() == HttpMethod.GET) {
            Object input = null;
            if (invoker.hasInput()) {
                QueryReader reader = (QueryReader)invoker.getBindingContext().get(QueryReader.class.getName());
                try {
                    input = reader.readValue(routingContext.request().params().iterator());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to unmarshal input", (Throwable)e);
                    routingContext.fail(400);
                    return;
                }
            }
            Object finalInput = input;
            this.executor.execute(() -> this.dispatch(routingContext, invoker, finalInput));
        } else if (routingContext.request().method() == HttpMethod.POST) {
            Buffer buff = routingContext.getBody();
            Object input = null;
            if (buff != null && buff.length() > 0) {
                ByteBufInputStream in = new ByteBufInputStream(buff.getByteBuf());
                ObjectReader reader = (ObjectReader)invoker.getBindingContext().get(ObjectReader.class.getName());
                try {
                    input = reader.readValue((InputStream)in);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to unmarshal input", (Throwable)e);
                    routingContext.fail(400);
                    return;
                }
            }
            final Object finalInput = input;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    VertxRequestHandler.this.dispatch(routingContext, invoker, finalInput);
                }
            });
        } else {
            routingContext.fail(405);
            log.error((Object)("Must be POST or GET for: " + invoker.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(RoutingContext routingContext, FunctionInvoker invoker, Object input) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)routingContext, null));
            }
        }
        this.currentVertxRequest.setCurrent(routingContext);
        try {
            FunqyRequestImpl funqyRequest = new FunqyRequestImpl((RequestContext)new RequestContextImpl(), input);
            FunqyResponseImpl funqyResponse = new FunqyResponseImpl();
            invoker.invoke((FunqyServerRequest)funqyRequest, (FunqyServerResponse)funqyResponse);
            funqyResponse.getOutput().emitOn(this.executor).subscribe().with(o -> {
                if (invoker.hasOutput()) {
                    routingContext.response().setStatusCode(200);
                    routingContext.response().putHeader("Content-Type", "application/json");
                    ObjectWriter writer = (ObjectWriter)invoker.getBindingContext().get(ObjectWriter.class.getName());
                    try {
                        routingContext.response().end(writer.writeValueAsString(o));
                    }
                    catch (JsonProcessingException e) {
                        log.error((Object)"Failed to marshal", (Throwable)e);
                        routingContext.fail(400);
                    }
                } else {
                    routingContext.response().setStatusCode(204);
                    routingContext.response().end();
                }
            }, t -> routingContext.fail(t));
        }
        catch (Exception e) {
            routingContext.fail((Throwable)e);
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }
}

